% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynPop.R
\name{dynPop}
\alias{BDM}
\alias{bifAttr}
\alias{dynPop}
\alias{estDem}
\alias{estEnv}
\alias{logDiscr}
\alias{popExp}
\alias{popLog}
\alias{popStr}
\alias{simpleBD}
\title{Population Dynamic Models}
\usage{
popExp(N0, lamb, tmax, intt = 1)

estEnv(N0, lamb, tmax, varr, npop = 1, ext = FALSE)

BDM(tmax, nmax = 10000, b, d, migr = 0, N0, barpr = FALSE)

simpleBD(tmax = 10, nmax = 10000, b = 0.2, d = 0.2, N0 = 10,
  cycles = 1000, barpr = FALSE)

estDem(N0 = 10, tmax = 10, nmax = 10000, b = 0.2, d = 0.2, migr = 0,
  nsim = 20, cycles = 1000, type = c("simpleBD", "BDM"), barpr = FALSE)

popLog(N0, tmax, r, K, ext = FALSE)

popStr(tmax, p.sj, p.jj, p.ja, p.aa, fec, ns, nj, na, rw, cl)

logDiscr(N0, tmax, rd, K)

bifAttr(N0, K, tmax, nrd, maxrd = 3, minrd = 1)
}
\arguments{
\item{N0}{number of individuals at start time.}

\item{lamb}{finite rate of population growth.}

\item{tmax}{maximum simulation time.}

\item{intt}{interval time size.}

\item{varr}{variance.}

\item{npop}{number of simulated populations.}

\item{ext}{extinction.}

\item{nmax}{maximum population size.}

\item{b}{birth rate.}

\item{d}{death rate.}

\item{migr}{migration. logical.}

\item{barpr}{show progress bar.}

\item{cycles}{number of cycles in simulation.}

\item{nsim}{number of simulated populations.}

\item{type}{type of stochastic algorithm.}

\item{r}{intrinsic growth rate.}

\item{K}{carrying capacity.}

\item{p.sj}{probability of seed survival.}

\item{p.jj}{probability of juvenile survival.}

\item{p.ja}{probability of transition from juvenile to adult phase.}

\item{p.aa}{probability of adult survival.}

\item{fec}{mean number of propagules per adult each cycle.}

\item{ns}{number of seeds at initial time.}

\item{nj}{number of juveniles at initial time.}

\item{na}{number of adults at initial time.}

\item{rw}{number of rows for the simulated scene.}

\item{cl}{number of columns for the simulated scene.}

\item{rd}{discrete growth rate.}

\item{nrd}{number of discrete population growth rate to simulate.}

\item{maxrd}{maximum discrete population growth rate.}

\item{minrd}{minimum discrete population growth rate.}
}
\value{
The functions return graphics with the simulation results, and a
matrix with the population size for deterministic and stochastic models.
}
\description{
Functions to simulate population dynamic models.
}
\details{
popExp simulates discrete and continuous exponential population growth.

estEnv simulates a geometric population growth with environmental
stochasticity.

BDM simulates simple stochastic birth death and immigration dynamics of a
population (Renshaw 1991). simpleBD another algorithm for simple birth dead
dynamics. This is usually more efficient than BDM but not implemented
migration.

estDem creates a graphic output based on BDM simulations.

Stochastic models uses lambda values taken from a normal distribution with
mean lambda and variance varr.

popLog simulates a logistic growth for continuous and discrete models.

popStr simulates a structured population dynamics, with Lefkovitch
matrices.

In popStr the number of patches in the simulated scene is defined by rw*cl.

logDiscr simulates a discrete logistic growth model.

bifAttr creates a bifurcation graphic for logistic discrete models.
}
\examples{

\dontrun{
popStr(p.sj=0.4, p.jj=0.6, p.ja=0.2, p.aa=0.9, fec=0.8, ns=100,nj=40,na=20, rw=30, cl=30, tmax=20)
}

}
\author{
Alexandre Adalardo de Oliveira and Paulo Inacio Prado
\email{ecovirtualpackage@gmail.com}
}
\references{
Gotelli, N.J. 2008. A primer of Ecology. 4th ed. Sinauer
Associates, 291pp. Renshaw, E. 1991. Modelling biological populations in
space and time Cambridge University Press. Stevens, M.H.H. 2009. A primer
in ecology with R. New York, Springer.
}
\seealso{
\code{\link{metaComp}}, \url{http://ecovirtual.ib.usp.br}
}
\keyword{dynamics}
\keyword{population}
\keyword{simulation}

