% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetSampler.R
\name{netsampler}
\alias{netsampler}
\title{Network Sampling Routine}
\usage{
netsampler(network_in, key_nodes_sampler = c("random", "lognormal",
  "Fisher log series", "exponential", "degree", "module"),
  neighbors_sampler = c("random", "exponential"), n_key_nodes = 10,
  n_neighbors = 0.5, hidden_modules = NULL, module_sizes = NULL,
  cluster_fn = igraph::cluster_edge_betweenness)
}
\arguments{
\item{network_in}{input network (as igraph object)}

\item{key_nodes_sampler}{sampling criteria for key nodes. See details.}

\item{neighbors_sampler}{sampling criteria for neighbors. see details.}

\item{n_key_nodes}{number of key nodes to sample.}

\item{n_neighbors}{number of first neighbors or fraction of first neighbors.
See details.}

\item{hidden_modules}{list of the modules to exclude
(max 10 modules; only the first numb_hidden are used)}

\item{module_sizes}{integer vector giving the size of each module. see details.}

\item{cluster_fn}{a clustering function, from \code{igraph::cluster_*}. Default is
\code{igraph::cluster_edge_betweeness}.  Only used to compute module sizes if not
provided.}
}
\value{
the original input network (as an igraph network object),
with the attribute \code{label} added to the edges and vertices indicating
if that edge or vertex was \code{sampled} or \code{unsampled}.
}
\description{
Network Sampling Routine
}
\details{
Algorithm first samples n_key_nodes according the the requested \code{key_nodes_sampler}
criterion.  For each key node, the requested number or fraction of neighbors is
then sampled according to the \code{neighbors_sampler} criterion.  Optionally, a list of
modules can be designated as "hidden" and will be excluded from sampling.

if \code{n_neighbors is greater than 1, assumes this is the number to sample.  If }n_neighbors\code{is between 0 and 1, assumes this is the fration of neighbors to sample.  (To sample 1 neighbor, use an explicit integer,}1L\code{ (or as.}integer(1)`)
to sample 100% of neighbors, use a numeric, 1.0.

Provide \code{module_sizes} list to improve performance.  If not provided, this will
will be calculated based on \code{igraph::cluster_edge_betweeness}.  Be sure to
provide a \code{module_sizes} vector whenever calling \code{netsampler} repeatedly on the
same network to avoid unnecessary performance hit from recalculating modules every
time.  See examples.
}
\examples{
\donttest{
set.seed(12345)
net <- netgen()
sample <- netsampler(net)

## Precompute `module_sizes` for replicate sampling of the same network:
 library(igraph)
 modules <- cluster_edge_betweenness(as.undirected(net))
 module_sizes <- vapply(igraph::groups(modules), length, integer(1))
 sample <- netsampler(net, module_sizes = module_sizes)

}

}
