% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetGen.R
\name{netgen}
\alias{netgen}
\title{netgen}
\usage{
netgen(net_size = 50, ave_module_size = 10, min_module_size = 6,
  min_submod_size = 1, net_type = c("mixed", "random", "scalefree",
  "nested", "bi-partite nested", "bi-partite random",
  "tri-trophic bipartite nested-random",
  "tri-trophic bipartite nested-bipartite nested", "bn", "br", "tt-bn-r",
  "tt-bn-bn"), ave_degree = 5, rewire_prob_global = 0.2,
  rewire_prob_local = 0, mixing_probs = c(0.2, 0.2, 0.2, 0.2, 0.2, 0,
  0), verbose = FALSE)
}
\arguments{
\item{net_size}{network size (number of nodes)}

\item{ave_module_size}{average module size}

\item{min_module_size}{cutoff for the minimum modules size}

\item{min_submod_size}{cutoff for submodules, used only for bipartite and tripartite networks}

\item{net_type}{network type, see details}

\item{ave_degree}{average degree of connection}

\item{rewire_prob_global}{probability any given edge should be rewired}

\item{rewire_prob_local}{probability that edges within a module should be rewire locally
(within the module)}

\item{mixing_probs}{module probabilities for first 7 types,
used for constructing mixed networks}

\item{verbose}{logical, default TRUE. Should a message report summary statistics?}
}
\value{
an \code{igraph} object
}
\description{
Randomly generate a wide range of interaction networks
}
\details{
network type is one of
\itemize{
\item mixed
\item random
\item scalefree
\item nested
\item bi-partite nested (or short-hand "bn")
\item bi-partite random (or short-hand "br")
\item tri-trophic bipartite nested-random. (Can use short-hand "ttbnr")
\item tri-trophic bipartite nested-bipartite nested (Can use short-hand "ttbnbn")
}

\strong{Valid Parameter Ranges}

Please note that not all combinations of parameters will create valid networks.
If an invalid combination is requested, \code{netgen()} will error with an informative
message.  A list of these constraints is provided below for reference.
\enumerate{
\item \code{net_size >= ave_module_size}. If `net_size = ave_module_size`` the program
generates a network with a single module.
\item \code{ave_module_size > min_module_size}
\item \code{ave_degree >= 1}. Preferably larger than 4, to ensure single component modules.
\item \code{rewire_prob_global = 0} produces completely uncoupled modules. To ensure a single
component network use \code{rewire_prob_global > 0} and sufficiently large.
\item \code{rewire_prob_local = 0} produces idealized modules.
Use \code{rewire_prob_local > 0} to add stochasticity to the modules.
\item For tripartite networks \code{min_module_size > min_submod_size}.
This also implies \code{min_module_size >= 2}.
\item For scalefree networks (or mixed networks involving scalefree modules)
\code{ave_degree < min_module_size}
\item For mixed networks \code{mixing_probs} need to sum to \code{1}. If the sum is larger
than one, only the first types, corresponding to \code{sum <=1}, will be sampled.
}
}
\examples{
library(EcoNetGen)
\donttest{
set.seed(12345)
net <- netgen()
adj_plot(net)
}
}
