% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eco.cbind.R
\name{eco.cbind}
\alias{eco.cbind}
\title{Combining the columns of two ecogen object}
\usage{
eco.cbind(e1, e2, ..., missing = 0)
}
\arguments{
\item{e1}{ecogen object.}

\item{e2}{ecogen object.}

\item{...}{Data frames to combine. Could be any combination of
the following: P","G","E" and "C"; or "ALL" (default).
If a "G" data frame is provided, the program also generates
 the GENIND slot coding the missing data as "0". "XY" slot
 is generated automatically if present.}

\item{missing}{Argument passed to \code{\link[adegenet]{df2genind}}.
It can take three values as described in that program ("NA", 0 or "MEAN").
Missing elements are treated as zero across alleles in the default option.}
}
\description{
Combining the columns of two ecogen object
}
\examples{
\dontrun{

data(eco.test)
eco.example <- eco.cbind(eco,eco,"ALL")
eco.example
eco.example2 <- eco.cbind(eco, eco,"P", "G", missing="NA")
eco.example2

}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

