% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot.EnsembleSample}
\alias{plot.EnsembleSample}
\title{Plot the ensemble output}
\usage{
\method{plot}{EnsembleSample}(x, variable = NULL, quantiles = c(0.05, 0.95), ...)
}
\arguments{
\item{x}{An \code{EnsembleSample} object.}

\item{variable}{The name of the variable to plot. This can either be a \code{character} string in the same form as the observation variable, or an index for the column in the observations data frame.}

\item{quantiles}{A \code{numeric} vector of length 2 giving the quantiles for which to plot ribbons if doing a full sampling of the ensemble model. The default is \code{c(0.05,0.95)}.}

\item{...}{Other arguments passed on to methods. Not currently used.}
}
\value{
The \code{ggplot} object.
}
\description{
Plots the latent variables predicted by the ensemble model, along with simulator outputs and observations.
}
\examples{
\donttest{
priors <- EnsemblePrior(4)
prior_density <- prior_ensemble_model(priors, M = 4)
samples <- sample_prior(observations = list(SSB_obs, Sigma_obs),
             simulators = list(list(SSB_miz, Sigma_miz),
                               list(SSB_ewe, Sigma_ewe),
                               list(SSB_fs, Sigma_fs),
                               list(SSB_lm, Sigma_lm)),
             priors = priors,
             sam_priors = prior_density)
plot(samples) #Plot the prior predictive density.
plot(samples, variable="Herring")
}
}
