% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{KalmanFilter_back}
\alias{KalmanFilter_back}
\title{Backwards Kalman filter}
\usage{
KalmanFilter_back(rhos, dee, R, Q, C, P, xhat, Time, y, obs)
}
\arguments{
\item{rhos}{A \code{numeric} containing the diagonal elements of the transition matrix of the evolution equation.}

\item{dee}{A \code{numeric} of the same length as \code{rho} containing the discrepancies or biases in the observation process.}

\item{R}{A \code{numeric} representing the variances of the observation process.}

\item{Q}{A \code{matrix} of dimensions \code{length(rho)} and \code{length(rho)} representing the covariance of the evolution process.}

\item{C}{A a \code{matrix} of dimensions \code{length(rho)} and \code{length(R)} representing the observation operator of the observation process.}

\item{P}{A \code{matrix} of dimensions \code{length(rho)} and \code{length(rho)} representing the covariance matrix of the first state of the evolution process.}

\item{xhat}{A \code{numeric} of the same length as \code{rho} representing the expectation of the first state of the evolution process.}

\item{Time}{A numeric The length of time of the dynamical linear model.}

\item{y}{A \code{matrix} of dimensions \code{Time} and \code{length(R)} of observations of the observation process.}

\item{obs}{A \code{matrix} of dimensions \code{Time} and \code{length(R)}. \code{1} means in the \code{i},\code{j}th element means that the \code{j}th output is observed at tim \code{i}.}
}
\value{
A \code{matrix} with dimensions \code{nrow(time)} and \code{length(xhat)} representing the most likely values of the latent variables.
}
\description{
Finds the most likely path through a dynamical linear model.
}
\details{
For the model with the evolution process \deqn{x_{t+1}\sim{}N(\rho{}\cdot{}x_{t},Q)} and observation process \deqn{y_{t}\sim{}N(\rho{}(x_{t} + \delta),diag(R))}.

Using the sequential Kalman filter, the function gives the mostly path of \eqn{x_{t}} for all \eqn{t}.
}
\examples{
\donttest{
fit <- fit_ensemble_model(observations = list(SSB_obs, Sigma_obs),
               simulators = list(list(SSB_ewe, Sigma_ewe, "EwE"),
                                 list(SSB_fs,  Sigma_fs, "FishSUMS"),
                                 list(SSB_lm,  Sigma_lm, "LeMans"),
                                 list(SSB_miz, Sigma_miz, "Mizer")),
               priors = EnsemblePrior(4,
               ind_st_params = IndSTPrior(parametrisation_form = "lkj",
               var_params= list(1,1), cor_params = 10, AR_params = c(2, 2))),
               full_sample = FALSE) #Only optimise in this case
transformed_data <- get_transformed_data(fit)
ex.fit <- fit@point_estimate$par
params <- get_parameters(ex.fit)
ret <- KalmanFilter_back(params$AR_params, params$lt_discrepancies,
                          transformed_data$all_eigenvalues_cov,params$SIGMA,
                          transformed_data$bigM, params$SIGMA_init, params$x_hat,
                          fit@ensemble_data@stan_input$time,transformed_data$new_data,
                          transformed_data$observation_available)
}
}
\references{
Chui, C.K. & Chen, G. (2009) Kalman Filtering with Real-Time Applications. Springer, Berlin, Heidelberg, Fourth Edtion.

Kalman, R. E. (1960) A new approach to linear filtering and prediction problems. Trans. ASME, J. Basic Eng., 82, pp. 35-45.
}
