% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stan_outputs.R
\name{generate_sample}
\alias{generate_sample}
\alias{get_transformed_data}
\alias{get_parameters}
\alias{get_mle}
\alias{gen_sample}
\title{Generate samples from a fitted ensemble model.}
\usage{
generate_sample(fit, num_samples = 1)

get_transformed_data(fit)

get_parameters(ex.fit, x = 1)

get_mle(x = 1, ex.fit, transformed_data, time)

gen_sample(x = 1, ex.fit, transformed_data, time)
}
\arguments{
\item{fit}{An \code{EnsembleFit} object.}

\item{num_samples}{A \code{numeric} specifying the number of samples to be generated. The default is 1.}

\item{ex.fit}{A \code{list} containing the samples / point estimate from the \code{EnsembleFit} object.}

\item{x}{A \code{numeric} specifying which sample from the posterior to use. The default is 1.}

\item{transformed_data}{A \code{list} of transformed input data.}

\item{time}{A \code{numeric} specifying the time for which the ensemble model was run.}
}
\value{
\code{generate_sample} gives a \code{list} of length 2, the first element being the MLE of latent variables and the second element being a set of samples of the latent variables.
\itemize{
\item If \code{fit} is a sampling of the ensemble model parameters, then:
\itemize{
\item \code{mle} is a \code{time}\eqn{\times (3M + 2) \times} \code{num_samples} \code{array}, where \eqn{M} is the number of simulators and \code{num_samples} is the number of samples from the ensemble model, giving the MLE of the latent variables for each available sample from the ensemble model.
\item \code{sample} is a \code{time}\eqn{\times (3M + 2) \times} \code{num_samples} \code{array}, giving a sample of the latent variables for each available sample of the ensemble model.
}
\item If \code{fit} is a point estimate of the ensemble model parameters, then:
\itemize{
\item \code{mle} is a \code{time}\eqn{\times (3M + 2) \times} 1 \code{array} giving the MLE of the latent variables for the point estimate of the ensemble model.
\item \code{sample} is a \code{time}\eqn{\times (3M + 2) \times} \code{num_samples} \code{array}, giving \code{num_samples} samples of the latent variables for the single point estimate of the ensemble model.
}
}

\code{get_transformed_data} gives a \code{list} of transformed input data.

\code{get_parameters} gives a \code{list} of ensemble parameters from the requested sample.

\code{get_mle} If \code{fit} is a sampling of the ensemble model parameters, then this is a \code{time}\eqn{\times (3M + 2) \times} \code{num_samples} \code{array}. If \code{fit} is a point estimate of the ensemble model parameters, then this is a \code{time}\eqn{\times (3M + 2) \times} 1 \code{array} giving the MLE of the latent variables for the point estimate of the ensemble model.

\code{gen_sample} If \code{fit} is a sampling of the ensemble model parameters, then this is a \code{time}\eqn{\times (3M + 2) \times} \code{num_samples} \code{array}, giving a sample of the latent variables for each available sample of the ensemble model. If \code{fit} is a point estimate of the ensemble model parameters, then this is a \code{time}\eqn{\times (3M + 2) \times} \code{num_samples} \code{array}.
}
\description{
Methods to generates samples of the latent variables from a fitted ensemble model.
}
\details{
The samples are created using the methods described in Strickland et. al. (2009) and Durbin and Koopman (2002).
}
\examples{
\donttest{
fit <- fit_ensemble_model(observations = list(SSB_obs, Sigma_obs),
               simulators = list(list(SSB_ewe, Sigma_ewe, "EwE"),
                                 list(SSB_fs,  Sigma_fs, "FishSUMS"),
                                 list(SSB_lm,  Sigma_lm, "LeMans"),
                                 list(SSB_miz, Sigma_miz, "Mizer")),
               priors = EnsemblePrior(4,
               ind_st_params = IndSTPrior(parametrisation_form = "lkj",
               var_params= list(1,1), cor_params = 10, AR_params = c(2, 2))),
               full_sample = FALSE) #Only optimise in this case
samples <- generate_sample(fit, num_samples = 2000)
}
}
\references{
J. Durbin, S. J. Koopman (2002) A simple and efficient simulation smoother for state space time series analysis Biometrika, Volume 89, Issue 3, August 2002, Pages 603–616,

Chris M.Strickland, Ian. W.Turner, Robert Denhamb, Kerrie L.Mengersena. Efficient Bayesian estimation of multivariate state space models Computational Statistics & Data Analysis Volume 53, Issue 12, 1 October 2009, Pages 4116-4125
}
