% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utils.R
\name{factorise}
\alias{factorise}
\alias{factorise.character}
\alias{factorise.data.frame}
\alias{factorise.default}
\alias{factorise.list}
\title{Put character vectors, columns of a data.frame or list elements as factor}
\usage{
factorise(x, logicals = FALSE, ...)

\method{factorise}{default}(x, logicals = FALSE, ...)

\method{factorise}{character}(x, logicals = FALSE, ...)

\method{factorise}{data.frame}(x, logicals = FALSE, ...)

\method{factorise}{list}(x, logicals = FALSE, ...)
}
\arguments{
\item{x}{a character vector, a data.frame or a list}

\item{logicals}{logical indicating if logical vectors should also be converted to factors. Defaults to FALSE.}

\item{...}{optional arguments passed on to the methods}
}
\value{
The updated x vector/data.frame or list where the character vectors or optionally logical elements are
converted to factors
}
\description{
Put character vectors, columns of a data.frame or list elements as factor if they are character strings
or optionally if they are logicals\cr
}
\examples{
x <- data.frame(x = 1:4, y = LETTERS[1:4], b = c(TRUE, FALSE, NA, TRUE), stringsAsFactors=FALSE)
str(factorise(x))
str(factorise(x, logicals = TRUE))
str(factorise(list(a = LETTERS, b = 1:10, c = pi, d = list(x = x))))
}
\seealso{
\code{\link{as.factor}}, \code{\link{factor}}
}

