% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simER.R
\name{simER}
\alias{simER}
\title{Simulates a sequential testing with evidence ratios for independent two-groups comparisons}
\usage{
simER(cohensd, nmin, n, ic = bic, plot = TRUE)
}
\arguments{
\item{cohensd}{Expected effect size}

\item{nmin}{Minimum sample size from which start computing ERs}

\item{n}{Total sample size}

\item{ic}{Indicates whether to use the aic or the bic.}

\item{plot}{If TRUE, produces a plot of the evolution of the ERs}
}
\description{
Simulates a sequential testing with evidence ratios for independent two-groups
comparisons, as a function of sample size and standardized mean difference
(Cohen's d).
}
\examples{
simER(cohensd = 0.6, nmin = 20, n = 200, ic = aic, plot = TRUE)
simER(cohensd = 0, nmin = 20, n = 200, ic = bic, plot = TRUE)

}
\seealso{
\code{\link{distER}}
}
\author{
Ladislas Nalborczyk <\email{ladislas.nalborczyk@gmail.com}>
}
