% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appPlots.R
\name{plotSum}
\alias{plotSum}
\alias{plotAnovaStats}
\alias{plottStats}
\alias{plotCIStats}
\title{Plots of model summaries}
\usage{
plotAnovaStats(fit0, barcols = NULL, preds = NULL, alpha = 0.05,
  type = "SS", width = 0.3)

plottStats(fit0, barcols = NULL, preds = NULL, alpha = 0.05,
  width = 0.3)

plotCIStats(fit0, barcols = NULL, preds = NULL, alpha = 0.05,
  stdunits = FALSE, width = 0.3)
}
\arguments{
\item{fit0}{is an lm object}

\item{barcols}{a vector of colours, one per term in lm}

\item{preds}{terms to include in plot}

\item{alpha}{significance level}

\item{type}{"SS" or "F", from type 3 Anova}

\item{width}{bar width}

\item{stdunits}{TRUE or FALSE. If TRUE, coefficients refer to standardised predictor units.}
}
\value{
a ggplot
}
\description{
Plots of model summaries
}
\section{Functions}{
\itemize{
\item \code{plotAnovaStats}: Plots barchart of F or SS from lm

\item \code{plottStats}: Plots barchart of t stats from lm

\item \code{plotCIStats}: Plots confidence intervals from lm
}}

\examples{
plotAnovaStats(lm(mpg ~ wt+hp+disp, data=mtcars))
plottStats(lm(mpg ~ wt+hp+disp, data=mtcars))
plotCIStats(lm(mpg ~ wt+hp+disp, data=mtcars))
}
