% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune.enm.R
\name{tune.enm}
\alias{tune.enm}
\alias{tune.parallel}
\alias{tune.regular}
\alias{cv.enm}
\alias{tune.train}
\alias{tune.validate}
\title{Iterate tuning of ENMs}
\usage{
tune.train(
  enm,
  occs.z,
  bg.z,
  mod.full,
  envs,
  tune.tbl.i,
  other.settings,
  partitions,
  quiet
)

tune.validate(
  enm,
  occs.train.z,
  occs.val.z,
  bg.train.z,
  bg.val.z,
  mod.k,
  nk,
  tune.tbl.i,
  other.settings,
  partitions,
  user.eval,
  quiet
)

tune.parallel(
  d,
  envs,
  enm,
  partitions,
  tune.tbl,
  other.settings,
  partition.settings,
  user.val.grps,
  occs.testing.z,
  numCores,
  parallelType,
  user.eval,
  quiet
)

tune.regular(
  d,
  envs,
  enm,
  partitions,
  tune.tbl,
  other.settings,
  partition.settings,
  user.val.grps,
  occs.testing.z,
  updateProgress,
  user.eval,
  quiet
)

cv.enm(
  d,
  envs,
  enm,
  partitions,
  tune.tbl.i,
  other.settings,
  partition.settings,
  user.val.grps,
  occs.testing.z,
  user.eval,
  quiet
)
}
\arguments{
\item{enm}{\link{ENMdetails} object}

\item{occs.z}{data.frame: the envs values for the coordinates at the full dataset occurrence records}

\item{bg.z}{data.frame: the envs values for the coordinates at the full dataset background records}

\item{mod.full}{model object: the model trained on the full dataset}

\item{envs}{RasterStack: environmental predictor variables. These should be in same geographic projection as occurrence data.}

\item{tune.tbl.i}{vector: single set of tuning parameters}

\item{other.settings}{named list: used to specify extra settings for the analysis. 
All of these settings have internal defaults, so if they are not specified the analysis will be run 
with default settings. See Details for descriptions of these settings.}

\item{partitions}{character: name of partitioning technique (see \code{?partitions})}

\item{quiet}{boolean: if TRUE, silence all function messages (but not errors).}

\item{occs.train.z}{data.frame: the envs values for the coordinates at the training occurrence records}

\item{occs.val.z}{data.frame: the envs values for the coordinates at the validation occurrence records}

\item{bg.train.z}{data.frame: the envs values for the coordinates at the training background records}

\item{bg.val.z}{data.frame: the envs values for the coordinates at the validation background records}

\item{mod.k}{model object: the model trained on the training dataset that becomes evaluated on the validation data}

\item{nk}{numeric: the number of folds (i.e., partitions) -- will be equal to \code{kfolds} for random partitions}

\item{user.eval}{function: custom function for specifying performance metrics not included in \pkg{ENMeval}.
The function must first be defined and then input as the argument \code{user.eval}. 
This function should have a single argument called \code{vars}, which is a list that includes different data 
that can be used to calculate the metric. See Details below and the vignette for a worked example.}

\item{d}{data frame: data frame from \code{ENMevaluate()} with occurrence and background coordinates (or coordinates plus predictor variable values) and partition group values}

\item{tune.tbl}{data frame: all combinations of tuning parameters}

\item{partition.settings}{named list: used to specify certain settings for partitioning schema.
See Details and ?partitions for descriptions of these settings.}

\item{user.val.grps}{matrix / data frame: user-defined validation record coordinates and predictor variable values. 
This is used internally by \code{ENMnulls()} to force each null model to evaluate with empirical validation data,
and does not have any current use when running \code{ENMevaluate()} independently.}

\item{occs.testing.z}{data.frame: when fully withheld testing data is provided, the envs values for the 
coordinates at the testing occurrence records}

\item{numCores}{numeric: number of cores to use for parallel processing. If NULL, all available cores will be used.}

\item{parallelType}{character: either "doParallel" or "doSNOW" (default: "doSNOW") .}

\item{updateProgress}{boolean: if TRUE, use shiny progress bar. This is only for use in shiny apps.}
}
\description{
Internal functions to tune and summarize results for ecological niche models (ENMs) iteratively across a range of user-specified tuning settings. 
See \link{ENMevaluate} for descriptions of shared arguments.
Function \code{tune.parallel()} tunes ENMs with parallelization. Function \code{cv.enm()} calculates training and validation evaluation statistics for one set of specified tuning parameters.

Validation CBI is calculated here with background values, not raster data, in order
to standardize the methodology for both training and validation data for spatial partitions, as ENMeval
does not mask rasters to partition areas and hence does not have partitioned raster data. Further, 
predictions for occurrence and background localities are combined as input for the parameter "fit" in 
\code{ecospat::ecospat_boyce()} because the interval is determined from "fit" only, and if test occurrences 
all have higher predictions than the background, the interval will be cut short.
}
