% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive.plot.enmtools.species.R
\name{interactive.plot.enmtools.species}
\alias{interactive.plot.enmtools.species}
\title{Plot an enmtools.species object on an interactive map}
\usage{
\method{interactive.plot}{enmtools.species}(
  x,
  map.provider = "Esri.WorldPhysical",
  cluster.points = FALSE,
  ...
)
}
\arguments{
\item{x}{entools.species object to plot}

\item{map.provider}{Name of a map provider for the underlying interactive base map.
Default is "Esri.WorldPhysical", and attractive topographic map with no place labels. A
preview of all map provider options can be viewed at \url{http://leaflet-extras.github.io/leaflet-providers/preview/}}

\item{cluster.points}{Should points be clustered? If TRUE, points close together
will be grouped into clusters that can be interactively expanded by clicking
on them.}

\item{...}{other arguments (not used currently)}
}
\value{
An interactive leaflet plot visualizing the data present in the species object.
}
\description{
Function that take an \code{\link{enmtools.species}} object and plots an
interactive map of the presence points, background points (if applicable), and
species range raster (if applicable). This function uses \code{\link[leaflet]{leaflet}} for mapping
and will only function properly if you have an active internet connection.
}
