% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUCell.R
\name{Execute_AUCell}
\alias{Execute_AUCell}
\title{AUCell methods to calculate EMT score}
\usage{
Execute_AUCell(geneExp, geneList, colnames)
}
\arguments{
\item{geneExp}{A numeric matrix of gene expression values}

\item{geneList}{A list of signature gene sets}

\item{colnames}{A character string specifying the name to assign to the column containing the scores in the output data frame.}
}
\value{
A data frame containing sample/cell ID and EMT scores
}
\description{
AUCell methods to calculate EMT score
}
\examples{
library(curl)
url <- "https://zenodo.org/record/15213845/files/geneExp.rda"
destfile <- tempfile(fileext = ".rda")
download.file(url, destfile, mode = "wb")
load(destfile)
data(Panchy_et_al_E_signature)
Execute_AUCell(geneExp, geneList = Panchy_et_al_E_signature, colnames = "Escore")
}
