% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/define.limits.R
\name{define.limits}
\alias{define.limits}
\title{Define mode limits by mouse clicks.}
\usage{
define.limits(data, n, classunits)
}
\arguments{
\item{data}{Output of \code{\link{test.robustness}}, a list with several
objects.}

\item{n}{Numeric scalar with number of target end-members (i.e. half the
number of limits).}

\item{classunits}{Numeric vector, optional class units (e.g. micrometers or
phi-units).}
}
\value{
Numeric matrix with limit classes. The first row contains lower
limits, the second row upper limits for each end-member.
}
\description{
This function allows to define limits for robust end-members by mouse clicks
on a combined plot output, showing a histogram and all end-members together.
Clicks must be placed in the order lower limit, upper limit - for each
end-member successively.
}
\examples{
## load example data set
data(X, envir = environment())

## Test robustness
q <- 4:7
l <- seq(from = 0, to = 0.1, by = 0.02)
TR <- test.robustness(X = X, q = q, l = l)

## define 2 limits by mouse clicks (uncomment to use).
# limits <- define.limits(data = TR, n = 2)
# limits
}
\author{
Michael Dietze, Elisabeth Dietze
}
\seealso{
\code{\link{test.robustness}}, \code{\link{robust.EM}}
}
\keyword{EMMA}

