% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting.R
\name{auto_burn}
\alias{auto_burn}
\title{Runs burn-in for emc.}
\usage{
auto_burn(
  emc,
  preburn = 150,
  p_accept = 0.8,
  step_size = 100,
  verbose = FALSE,
  verboseProgress = FALSE,
  fileName = NULL,
  stop_criteria = NULL,
  particles = NULL,
  particle_factor = 50,
  cores_per_chain = 1,
  cores_for_chains = length(emc),
  max_tries = 20,
  n_blocks = 1
)
}
\arguments{
\item{emc}{An emc object}

\item{preburn}{An integer. The number of iterations run for preburn stage.}

\item{p_accept}{A double. The target acceptance probability of the MCMC process.
This fine-tunes the width of the search space to obtain the desired acceptance probability. Defaults to .8}

\item{step_size}{An integer. After each step, the stopping requirements as
specified by \code{stop_criteria} are checked and proposal distributions are updated. Defaults to 100.}

\item{verbose}{Logical. Whether to print messages between each step with the current status regarding the stop_criteria.}

\item{verboseProgress}{Logical. Whether to print a progress bar within each step or not. Will print one progress bar for each chain and only if cores_for_chains = 1.}

\item{fileName}{A string. If specified will autosave emc at this location on every iteration.}

\item{stop_criteria}{A list. Defines the stopping criteria and for which types of parameters these should hold. See \code{?fit}.}

\item{particles}{An integer. How many particles to use, default is \code{NULL} and \code{particle_factor} is used instead.
If specified will override \code{particle_factor}.}

\item{particle_factor}{An integer. \code{particle_factor} multiplied by the square root of the number of sampled parameters determines the number of particles used.}

\item{cores_per_chain}{An integer. How many cores to use per chain.
Parallelizes across participant calculations. Only available on Linux or Mac OS.
For Windows, only parallelization across chains (\code{cores_for_chains}) is available.}

\item{cores_for_chains}{An integer. How many cores to use across chains.
Defaults to the number of chains. the total number of cores used is equal to \code{cores_per_chain} * \code{cores_for_chains}.}

\item{max_tries}{An integer. How many times should it try to meet the finish
conditions as specified by stop_criteria? Defaults to 20. max_tries is ignored if the required number of iterations has not been reached yet.}

\item{n_blocks}{An integer. Number of blocks. Will block the parameter chains such that they are updated in blocks. This can be helpful in extremely tough models with a large number of parameters.}
}
\value{
An emc object
}
\description{
Special instance of \code{run_emc}, with default arguments specified for completing burn_in.
Will run both preburn and burn.
}
