% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.ELMCoxBAR.R
\name{predict.ELMCoxBAR}
\alias{predict.ELMCoxBAR}
\title{Predict.ELMCoxBAR}
\usage{
\method{predict}{ELMCoxBAR}(object, newdata, ...)
}
\arguments{
\item{object}{An object that inherits from class ELMBJEN.}

\item{newdata}{A data frame in which to look for variables with which to predict.}

\item{...}{Additional arguments.}
}
\value{
produces a vector of predictions or a matrix of predictions
}
\description{
Predicting  with an ELMCoxBAR model
}
\examples{
set.seed(123)
require(ELMSurv)
require(survival)
#Lung DATA
data(lung)
lung=na.omit(lung)
lung[,3]=lung[,3]-1
n=dim(lung)[1]
L=sample(1:n,ceiling(n*0.5))
trset<-lung[L,]
teset<-lung[-L,]
rii=c(2,3)
# Default with lin_kernel 
elmsurvmodel=ELMCoxBAR(x=trset[,-rii],y=Surv(trset[,rii[1]], trset[,rii[2]]))
# with  the RBF kernel
elmsurvmodel=ELMCoxBAR(x=trset[,-rii],y=Surv(trset[,rii[1]], 
trset[,rii[2]]),Kernel_type="RBF_kernel",Kernel_para=c(2,1))
#The predicted linear predictor
testprelin=predict(elmsurvmodel,teset[,-c(rii)])
}
\references{
\itemize{
  \item Wang, H, Li, G. Extreme learning machine Cox model for high-dimensional survival analysis. Statistics in Medicine. 2019; 38:2139-2156.
 }
}
\author{
Hong Wang
}
