% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BatchCorrection.R
\name{plotBatchData}
\alias{plotBatchData}
\title{Plot ELISA data for one batch}
\usage{
plotBatchData(batch, graph.file = NULL)
}
\arguments{
\item{batch}{batch data objects with either raw or analyzed data.}

\item{graph.file}{characters as the output graph file name. If specified, a 
SVG (*.svg) graph will be saved to the disk. Otherwise, the graph 
will be send to the stdout.}
}
\value{
characters which is the graph file name, if graph.file is specified. NULL
otherwise.
}
\description{
Plot the individual batch data for visualization.
}
\details{
If the data has been analysed, a fitted line will be drawn too.
}
\examples{
#load the library
library(ELISAtools)

#get file folder
dir_file<-system.file("extdata", package="ELISAtools")

#load the data
batches<-loadData(file.path(dir_file,"design.txt"))

#plot the raw batch 1 data
plotBatchData(batches[[1]]);


}
