% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_function.R
\name{MLICwgee}
\alias{MLICwgee}
\title{Model selection based on MLIC under the syntax of WGEE (Main function).}
\usage{
MLICwgee(models, candidate.cor.sets, data, model_mis, family,r,id,time)
}
\arguments{
\item{models}{A list of formulas. See corresponding documentation to wgeesel.}

\item{candidate.cor.sets}{A vector containing candidate correlation structures. It can be any subset of c("independence","exchangeable", "ar1").}

\item{data}{A data frame containing the variables in both the main model and the missing model.}

\item{model_mis}{A formula used in the missing data model.}

\item{family}{A description of the error distribution and link function to be used in the model.
The details are given under "Details".}

\item{r}{A vector indicating the observation of data: 1 for observed records (both outcome and covariates are observed for a given subject),
and 0 for unobserved records.
The default setup is that all data are observed.}

\item{id}{A vector indicating subject id.}

\item{time}{The number of observations in total for each subject.}
}
\value{
A list with two items: model selection result based on ELCIC;
An object of "wgee" based on the selected model.
}
\description{
The function \code{\link{MLICwgee}} provides the model selection under the syntax of the wgeesel package.
}
\details{
Three commonly used distributions are considered: "gaussian", "poisson", "binomial".
For the current package, the identity link is considered for a "gaussian" distribution;
the log link is considered for a "poisson" distribution; the logit link is considered for a "binomial" distribution;n;
}
\examples{
## tests
# load data
data(wgeesimdata)
family<-binomial()
r<-wgeesimdata$obs_ind
id<-wgeesimdata$id
time<-3
dat <- data.frame(y=wgeesimdata$y, wgeesimdata$x,x_mis1=wgeesimdata$x_mis[,2])
models <- list(y~x1+x2)
model_mis<-r~x_mis1
candidate.cor.sets<-c("exchangeable")
##not run
#output<-MLICwgee(models, candidate.cor.sets,data=dat,model_mis,family,r,id,time)
#output$model.selection
#output$wgee.output


}
