% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R
\docType{class}
\name{DataTemporalMap-class}
\alias{DataTemporalMap-class}
\title{Class DataTemporalMap}
\value{
A \code{DataTemporalMap} object.
}
\description{
Class \code{DataTemporalMap} object contains the statistical distributions of data estimated at a 
specific time period. Both relative and absolute frequencies are included.
}
\details{
Objects of this class are generated automatically by the \code{estimateDataTemporalMap} function, 
but its construction and extension is open towards fostering its use through external methods. 
E.g., one may use additional probability distribution estimation methods, or even construct 
compatible DataTemporalMaps for other unstructured data such as images or free text.
}
\section{Slots}{

\describe{
\item{\code{probabilityMap}}{v-by-d numerical \code{matrix} representing the probability distribution 
temporal map (relative frequency).}

\item{\code{countsMap}}{v-by-d numerical \code{matrix} representing the counts temporal map 
(absolute frequency).}

\item{\code{dates}}{d-dimensional \code{Date} array of the temporal batches.}

\item{\code{support}}{v-by-1 numerical or character \code{matrix} representing the support 
(the value at each bin) of probabilityMap and countsMap.}

\item{\code{variableName}}{name of the variable (character).}

\item{\code{variableType}}{type of the variable (character) among "numeric", "character", "Date" and "factor".}

\item{\code{period}}{batching period among "week", "month" and "year".}
}}

\examples{
\dontrun{

# Generation through estimateDataTemporalMap function:
dataset <- read.csv2(system.file("extdata",
                                   "nhdsSubset.csv",
                                   package="EHRtemporalVariability"), 
                     sep  = ",",
                     header = TRUE, 
                     na.strings = "", 
                     colClasses = c( "character", "numeric", "factor",
                                     "numeric" , rep( "factor", 22 ) ) )

datasetFormatted <- EHRtemporalVariability::formatDate(
                     input         = dataset,
                     dateColumn    = "date",
                     dateFormat = "\%y/\%m")

probMaps <- estimateDataTemporalMap(data = datasetPheWAS, 
                     dateColumnName = "date", 
                     period         = "month")

class( probMaps[[1]] ) 

# Manual generation:
countsMatrix <- matrix(sample.int(25, size = 12*10, replace = TRUE), nrow = 12, ncol = 10)
probabilityMatrix <- sweep(countsMatrix,1,rowSums(countsMatrix),"/")
dates <- seq(Sys.Date(),(Sys.Date()+30*12),30)
x <- DataTemporalMap(probabilityMap = probabilityMatrix, 
countsMap = countsMatrix, dates = dates, support = as.matrix(1:25), 
variableName = "example", variableType = "numerical", period = "month")
}
}
