% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilsBuild.R
\name{build-internal}
\alias{build-internal}
\alias{tstrsplit2}
\alias{convert}
\alias{entVal}
\alias{entStart}
\alias{entStop}
\alias{remainder}
\alias{getCombosIx}
\alias{getPaths}
\alias{getOpt}
\alias{getCosts}
\alias{findOptPath}
\alias{stdRoute}
\alias{grp}
\alias{anchorByStrength}
\alias{combineGroups}
\alias{makeCombos}
\alias{findRareValues}
\title{Internal functions for buildDose process}
\description{
These internal functions aid the \code{\link{buildDose}} function and process.
}
\details{
\code{tstrsplit2}: a wrapper for the \code{\link[data.table]{tstrsplit}} function in \pkg{data.table} 
with some additional formatting 

\code{convert}: formats final results that are returned in \code{\link{buildDose}}, including 
separating the extracted expression from its start and stop position

\code{entVal}: isolates the extracted expression from a string of the format 
"extracted expression::start position::stop position"

\code{entStart}: isolates the start position from a string of the format 
"extracted expression::start position::stop position"

\code{entStop}: isolates the stop position from a string of the format 
"extracted expression::start position::stop position"

\code{remainder}: performs some formatting for paths containing NA values

\code{getCombosIx}: forms the individual paths within the \code{getPaths} function

\code{getPaths}: builds paths from entity pairings using other helper function \code{getCombosIx}

\code{getOpt}: takes in the possible paths as well as the cost computations from \code{getCosts}, 
combines costs at the path level using the helper functions \code{remainder} and \code{getPaths}, 
and returns the path with the minimum cost

\code{getCosts}: computes the distance for each path based on the distance method specified in \code{buildDose} 

\code{findOptPath}: uses the helper functions \code{getCosts} and \code{getOpt} to 
determine the optimal path based on the selected distance method

\code{stdRoute}: standardize the "route" entity. This function is also used in the 
\code{collapseDose} function and process.

\code{grp}: groups drug entities based on a particular anchor point (e.g. strength 
or dose)

\code{anchorByStrength}: forms subgroups of entities by anchoring to strength. This is done within existing groups 
which are anchored by drug name

\code{combineGroups}: determines how to form groups of the entities based on the complexity of the extraction (i.e., 
number of extractions for each entity)

\code{makeCombos}: takes all extracted entities and puts them into groups based on position and minimum cost of paths. 
This is the highest level function within \code{\link{buildDose}}; it calls other helper functions including \code{combineGroups} 
and \code{anchorByStrength}.

\code{findRareValues}: find rare values for each column in a data.frame; rare defaults to less than two percent.
}
\keyword{internal}
