% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotConcPred.R
\name{plotConcPred}
\alias{plotConcPred}
\title{Plot of Observed Concentration versus Estimated Concentration}
\usage{
plotConcPred(eList, concMax = NA, logScale = FALSE, printTitle = TRUE,
  tinyPlot = FALSE, cex = 0.8, cex.axis = 1.1, cex.main = 1.1,
  customPar = FALSE, col = "black", lwd = 1, randomCensored = FALSE,
  concLab = 1, usgsStyle = FALSE, ...)
}
\arguments{
\item{eList}{named list with at least the Sample and INFO dataframes}

\item{concMax}{number specifying the maximum value to be used on the vertical axis, default is NA (which allows it to be set automatically by the data)}

\item{logScale}{logical, default TRUE, TRUE indicates x and y axes are on a log scale. FALSE indicates both x and y are on an arithmetic scale.}

\item{printTitle}{logical variable if TRUE title is printed, if FALSE not printed (this is best for a multi-plot figure)}

\item{tinyPlot}{logical variable, if TRUE plot is designed to be plotted small, as a part of a multipart figure, default is FALSE}

\item{cex}{numerical value giving the amount by which plotting symbols should be magnified}

\item{cex.axis}{magnification to be used for axis annotation relative to the current setting of cex}

\item{cex.main}{magnification to be used for main titles relative to the current setting of cex}

\item{customPar}{logical defaults to FALSE. If TRUE, par() should be set by user before calling this function 
(for example, adjusting margins with par(mar=c(5,5,5,5))). If customPar FALSE, EGRET chooses the best margins depending on tinyPlot.}

\item{col}{color of points on plot, see ?par 'Color Specification'}

\item{lwd}{number line width}

\item{randomCensored}{logical. Show censored values as randomized.}

\item{concLab}{object of concUnit class, or numeric represented the short code, 
or character representing the descriptive name.}

\item{usgsStyle}{logical option to use USGS style guidelines. Setting this option
to TRUE does NOT guarantee USGS compliance. It will only change automatically
generated labels}

\item{\dots}{arbitrary graphical parameters that will be passed to genericEGRETDotPlot function (see ?par for options)}
}
\description{
Data come from named list, which contains a Sample dataframe with the sample data, 
and an INFO dataframe with metadata. 

Although there are a lot of optional arguments to this function, most are set to a logical default.
}
\examples{
eList <- Choptank_eList
# Water year:
plotConcPred(eList)

# Graphs consisting of Jun-Aug
eList <- setPA(eList, paStart=6,paLong=3)
plotConcPred(eList)
}
\seealso{
\code{\link{selectDays}}, \code{\link{genericEGRETDotPlot}}
}
\keyword{graphics}
\keyword{statistics}
\keyword{water-quality}
