% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableChange.R, R/tableChangeSingle.R
\name{tableChange}
\alias{tableChange}
\alias{tableChangeSingle}
\title{Create a table of the changes in flow-normalized values between various points in time in the record}
\usage{
tableChange(eList, fluxUnit = 9, yearPoints = NA)

tableChangeSingle(eList, fluxUnit = 9, yearPoints = NA, flux = FALSE)
}
\arguments{
\item{eList}{named list with at least the Daily and INFO dataframes}

\item{fluxUnit}{object of fluxUnit class. \code{\link{printFluxUnitCheatSheet}}, or numeric represented the short code, or character representing the descriptive name.}

\item{yearPoints}{numeric vector listing the years for which the change or slope computations are made, they need to be in chronological order.  For example yearPoints=c(1975,1985,1995,2005), default is NA (which allows the program to set yearPoints automatically)}

\item{flux}{logical if TRUE results are returned in flux, if FALSE concentration. Default is set to FALSE.}
}
\value{
dataframe with Year1, Year2, change[mg/L], slope[mg/L], change[percent], slope[percent] columns. The data in each row is the change or slope calculated from Year1 to Year2
}
\description{
These tables describe trends in flow-normalized concentration and in flow-normalized flux. 
They are described as changes in real units or in percent and as slopes in real units per year or in percent per year.
They are computed over pairs of time points.  These time points can be user-defined or
they can be set by the program to be the final year of the record and a set of years that are multiples of 5 years prior to that.
tableChangeSingle is a version of the same code that will produce output only for flow-normalized concentration or flow-normalized flux, but not both
}
\examples{
eList <- Choptank_eList
# Water Year:
\donttest{
tableChange(eList, fluxUnit = 8, yearPoints = c(1980, 1995, 2011))
tableChange(eList, fluxUnit = 5) 
# Winter:
eList <- setPA(eList, paStart = 12, paLong = 3)
tableChange(eList, fluxUnit = 8, yearPoints = c(1980, 1995, 2011))

# Water Year:
eList <- setPA(eList, paStart = 10, paLong = 12)
#This returns concentration ASCII table in the console:
tableChangeSingle(eList, fluxUnit = 8, yearPoints = c(1980, 1995, 2011), flux = FALSE)
#Returns a data frame:
change <- tableChangeSingle(eList, fluxUnit = 8, yearPoints=c(1980, 1995, 2011), flux = FALSE) 
#This returns flux values as a data frame:
df <- tableChangeSingle(eList, fluxUnit = 8, yearPoints=c(1980, 1995, 2011), flux = TRUE)  
# Winter Concentration only:
eList <- setPA(eList, paStart = 12, paLong = 3)
df.winter <- tableChangeSingle(eList, fluxUnit = 8, yearPoints=c(1980, 1995, 2011), flux = FALSE)

}
}
\keyword{statistics}
\keyword{water-quality}
