% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compressData.r
\name{compressData}
\alias{compressData}
\title{Compress sample data frame}
\usage{
compressData(data, verbose = TRUE, interactive = NULL)
}
\arguments{
\item{data}{dataframe contains at least dateTime, value, code columns}

\item{verbose}{logical specifying whether or not to display progress message}

\item{interactive}{logical deprecated. Use 'verbose' instead}
}
\value{
data frame returnDataFrame data frame containing dateTime, ConcHigh, ConcLow, Uncen
}
\description{
Using raw data that has at least dateTime, value, code, populates the measured data portion of the Sample dataframe used in EGRET.
ConcLow  = Lower bound for an observed concentration
ConcHigh = Upper bound for an observed concentration
Uncen    = 1 if uncensored, 0 if censored
}
\examples{
dateTime <- c('1985-01-01', '1985-01-02', '1985-01-03')
comment1 <- c("","","")
value1 <- c(1,2,3)
comment2 <- c("","<","")
value2 <- c(2,3,4)
comment3 <- c("","","<")
value3 <- c(3,4,5)
dataInput <- data.frame(dateTime, comment1, value1, 
      comment2, value2, 
      comment3, value3, stringsAsFactors=FALSE)
compressData(dataInput)
}
\keyword{WRTDS}
\keyword{flow}
