% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EGA.estimate.R
\name{EGA.estimate}
\alias{EGA.estimate}
\title{Estimates \code{\link[EGAnet]{EGA}} for Multidimensional Structures}
\usage{
EGA.estimate(
  data,
  n = NULL,
  corr = c("auto", "cor_auto", "pearson", "spearman"),
  na.data = c("pairwise", "listwise"),
  model = c("BGGM", "glasso", "TMFG"),
  algorithm = c("leiden", "louvain", "walktrap"),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{data}{Matrix or data frame.
Should consist only of variables to be used in the analysis}

\item{n}{Numeric (length = 1).
Sample size if \code{data} provided is a correlation matrix}

\item{corr}{Character (length = 1).
Method to compute correlations.
Defaults to \code{"auto"}.
Available options:

\itemize{

\item \code{"auto"} --- Automatically computes appropriate correlations for
the data using Pearson's for continuous, polychoric for ordinal,
tetrachoric for binary, and polyserial/biserial for ordinal/binary with
continuous. To change the number of categories that are considered
ordinal, use \code{ordinal.categories}
(see \code{\link[EGAnet]{polychoric.matrix}} for more details)

\item \code{"cor_auto"} --- Uses \code{\link[qgraph]{cor_auto}} to compute correlations. 
Arguments can be passed along to the function

\item \code{"pearson"} --- Pearson's correlation is computed for all 
variables regardless of categories

\item \code{"spearman"} --- Spearman's rank-order correlation is computed 
for all variables regardless of categories

}

For other similarity measures, compute them first and input them
into \code{data} with the sample size (\code{n})}

\item{na.data}{Character (length = 1).
How should missing data be handled?
Defaults to \code{"pairwise"}.
Available options:

\itemize{

\item \code{"pairwise"} --- Computes correlation for all available cases between
two variables

\item \code{"listwise"} --- Computes correlation for all complete cases in the dataset

}}

\item{model}{Character (length = 1).
Defaults to \code{"glasso"}.
Available options:

\itemize{

\item \code{"BGGM"} --- Computes the Bayesian Gaussian Graphical Model.
Set argument \code{ordinal.categories} to determine
levels allowed for a variable to be considered ordinal.
See \code{?BGGM::estimate} for more details

\item \code{"glasso"} --- Computes the GLASSO with EBIC model selection.
See \code{\link[EGAnet]{EBICglasso.qgraph}} for more details

\item \code{"TMFG"} --- Computes the TMFG method.
See \code{\link[EGAnet]{TMFG}} for more details

}}

\item{algorithm}{Character or 
\code{\link{igraph}} \code{cluster_*} function (length = 1).
Defaults to \code{"walktrap"}.
Three options are listed below but all are available
(see \code{\link[EGAnet]{community.detection}} for other options):

\itemize{

\item \code{"leiden"} --- See \code{\link[igraph]{cluster_leiden}} for more details

\item \code{"louvain"} --- By default, \code{"louvain"} will implement the Louvain algorithm using 
the consensus clustering method (see \code{\link[EGAnet]{community.consensus}} 
for more information). This function will implement
\code{consensus.method = "most_common"} and \code{consensus.iter = 1000} 
unless specified otherwise

\item \code{"walktrap"} --- See \code{\link[igraph]{cluster_walktrap}} for more details

}}

\item{verbose}{Boolean (length = 1).
Whether messages and (insignificant) warnings should be output.
Defaults to \code{FALSE} (silent calls).
Set to \code{TRUE} to see all messages and warnings for every function call}

\item{...}{Additional arguments to be passed on to
\code{\link[EGAnet]{auto.correlate}}, 
\code{\link[EGAnet]{network.estimation}},
\code{\link[EGAnet]{community.detection}}, and
\code{\link[EGAnet]{community.consensus}}}
}
\value{
Returns a list containing:

\item{network}{A matrix containing a network estimated using 
\code{link[EGAnet]{network.estimation}}}

\item{wc}{A vector representing the community (dimension) membership
of each node in the network. \code{NA} values mean that the node
was disconnected from the network}

\item{n.dim}{A scalar of how many total dimensions were identified in the network}

\item{cor.data}{The zero-order correlation matrix}

\item{n}{Number of cases in \code{data}}
}
\description{
A basic function to estimate \code{\link[EGAnet]{EGA}} for multidimensional structures.
This function does \emph{not} include the unidimensional check and it does not
plot the results. This function can be used as a streamlined approach
for quick \code{\link[EGAnet]{EGA}} estimation when unidimensionality or visualization
is not a priority
}
\examples{
# Obtain data
wmt <- wmt2[,7:24]

# Estimate EGA
ega.wmt <- EGA.estimate(data = wmt)

# Estimate EGA with TMFG
ega.wmt.tmfg <- EGA.estimate(data = wmt, model = "TMFG")

# Estimate EGA with an {igraph} function (Fast-greedy)
ega.wmt.greedy <- EGA.estimate(
  data = wmt,
  algorithm = igraph::cluster_fast_greedy
)

}
\references{
\strong{Original simulation and implementation of EGA} \cr
Golino, H. F., & Epskamp, S. (2017).
Exploratory graph analysis: A new approach for estimating the number of dimensions in psychological research.
\emph{PLoS ONE}, \emph{12}, e0174035.

\strong{Introduced unidimensional checks, simulation with continuous and dichotomous data} \cr
Golino, H., Shi, D., Christensen, A. P., Garrido, L. E., Nieto, M. D., Sadana, R., & Thiyagarajan, J. A. (2020).
Investigating the performance of Exploratory Graph Analysis and traditional techniques to identify the number of latent factors: A simulation and tutorial.
\emph{Psychological Methods}, \emph{25}, 292-320.


\strong{Compared all} \code{\link{igraph}} \strong{community detection algorithms, simulation with continuous and polytomous data} \cr
Christensen, A. P., Garrido, L. E., Guerra-Pena, K., & Golino, H. (2023).
Comparing community detection algorithms in psychometric networks: A Monte Carlo simulation.
\emph{Behavior Research Methods}.
}
\seealso{
\code{\link[EGAnet]{plot.EGAnet}} for plot usage in \code{\link{EGAnet}}
}
\author{
Alexander P. Christensen <alexpaulchristensen at gmail.com> and Hudson Golino <hfg9s at virginia.edu>
}
