% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.EGA.plots.R
\name{compare.EGA.plots}
\alias{compare.EGA.plots}
\title{Visually Compares \code{\link{EGAnet}} plots}
\usage{
compare.EGA.plots(
  ...,
  input.list = NULL,
  base.plot = 1,
  labels,
  rows,
  columns,
  plot.args = list()
)
}
\arguments{
\item{...}{\code{\link{EGAnet}} objects}

\item{input.list}{List.
Bypasses \code{...} argument in favor of using a list
as an input}

\item{base.plot}{Numeric.
Plot to be used as the base for the configuration of the networks.
Uses the number of the order in which the plots are input.
Defaults to \code{1} or the first plot}

\item{labels}{Character vector.
Labels for each \code{\link{EGAnet}} object}

\item{rows}{Numeric.
Number of rows to spread plots across}

\item{columns}{Numeric.
Number of columns to spread plots down}

\item{plot.args}{List.
A list of additional arguments for the network plot.
For \code{plot.type = "qgraph"}:

\itemize{

\item{\strong{\code{vsize}}}
{Size of the nodes. Defaults to 6.}

}

(see \code{\link[GGally]{ggnet2}} for
full list of arguments):

\itemize{

\item{\strong{\code{vsize}}}
{Size of the nodes. Defaults to 6.}

\item{\strong{\code{label.size}}}
{Size of the labels. Defaults to 5.}

\item{\strong{\code{alpha}}}
{The level of transparency of the nodes, which might be a single value or a vector of values. Defaults to 0.7.}

\item{\strong{\code{edge.alpha}}}
{The level of transparency of the edges, which might be a single value or a vector of values. Defaults to 0.4.}

 \item{\strong{\code{legend.names}}}
{A vector with names for each dimension}

\item{\strong{\code{color.palette}}}
{The color palette for the nodes. For custom colors,
enter HEX codes for each dimension in a vector.
See \code{\link[EGAnet]{color_palette_EGA}} for
more details and examples}

}}
}
\value{
Visual comparison of \code{\link{EGAnet}} objects
}
\description{
Organizes EGA plots for comparison. Ensures that nodes are
placed in the same layout to maximize comparison. Community memberships
are also homogenized across EGA outputs to enhance interpretation
}
\examples{
# Obtain SAPA items
items <- psychTools::spi[,c(11:20)]

# Draw random samples
sample1 <- items[sample(1:nrow(items), 1000),]
sample2 <- items[sample(1:nrow(items), 1000),]

\donttest{# Estimate EGAs
ega1 <- EGA(sample1)
ega2 <- EGA(sample2)

# Compare EGAs via plot
compare.EGA.plots(
  ega1, ega2,
  base.plot = 1, # use "ega1" as base for comparison
  labels = c("Sample 1", "Sample 2"),
  rows = 1, columns = 2
)}

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
