% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.section.R
\name{methods.section}
\alias{methods.section}
\title{Automated Methods Section for \code{\link{EGAnet}} Objects}
\usage{
methods.section(
  ...,
  stats = c("net.loads", "net.scores", "dimensionStability", "itemStability")
)
}
\arguments{
\item{...}{\code{\link{EGAnet}} objects.
Available methods (more methods will be added soon!):

\itemize{

\item{\code{\link[EGAnet]{EGA}}}
{Exploratory graph analysis}

\item{\code{\link[EGAnet]{bootEGA}}}
{Bootstrap exploratory graph analysis}

\item{\code{\link[EGAnet]{UVA}}}
{Unique variable analysis}

}}

\item{stats}{Methods section for statistics in \code{\link{EGAnet}}.
Multiple statistics can be input.
Available statistics:

\itemize{

\item{\code{\link[EGAnet]{net.loads}}}
{Network loadings. Requires \code{\link[EGAnet]{EGA}} object to be input}

\item{\code{\link[EGAnet]{net.scores}}}
{Network scores. Requires \code{\link[EGAnet]{EGA}} object to be input}

\item{\code{\link[EGAnet]{dimensionStability}}}
{Structural consistency. Requires \code{\link[EGAnet]{bootEGA}} object to be input}

\item{\code{\link[EGAnet]{itemStability}}}
{Item stability. Requires \code{\link[EGAnet]{bootEGA}} object to be input}

}}
}
\value{
Automated HTML Methods section in your default browser
}
\description{
This function accepts \code{\link[EGAnet]{EGA}} objects
and generates a Methods section for your analysis. The output is
an HTML page containing the descriptions of the methods and parameters
as well as a Reference section for appropriate citation.
}
\examples{
\donttest{# Estimate EGA
## plot.type = "qqraph" used for CRAN checks
## plot.type = "GGally" is the default
ega.wmt <- EGA(data = wmt2[,7:24], plot.type = "qgraph")
}
# EGA Methods section
if(interactive()){
methods.section(ega.wmt)
}

\donttest{# Estimate standardized network loadings
wmt.loads <- net.loads(ega.wmt)$std
}
# EGA Methods section with network loadings
if(interactive()){
methods.section(ega.wmt, stats = "net.loads")
}

\dontrun{# bootEGA example
## plot.type = "qqraph" used for CRAN checks
## plot.type = "GGally" is the default
boot.wmt <- bootEGA(data = wmt2[,7:24], iter = 500, plot.type = "qgraph",
type = "parametric", ncores = 2)
}
# EGA and bootEGA Methods section
if(interactive()){
methods.section(ega.wmt, boot.wmt)
}

\donttest{# Estimate structural consistency
sc.wmt <- dimensionStability(boot.wmt)
}
# EGA and bootEGA Methods section with structural consistency and item stability
if(interactive()){
methods.section(boot.wmt, stats = c("dimensionStability", "itemStability"))
}

# EGA with network loadings and
# bootEGA Methods section with structural consistency and item stability
if(interactive()){
methods.section(ega.wmt, boot.wmt, stats = c("net.loads", "dimensionStability", "itemStability"))
}

}
