% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemStability.R
\name{itemStability}
\alias{itemStability}
\title{Item Stability Statistics from \code{\link[EGAnet]{bootEGA}}}
\usage{
itemStability(bootega.obj, IS.plot = TRUE, ...)
}
\arguments{
\item{bootega.obj}{A \code{\link[EGAnet]{bootEGA}} object}

\item{IS.plot}{Should the plot be produced for \code{item.replication}?
If \code{TRUE}, then a plot for the \code{item.replication} output will be produced.
Defaults to \code{TRUE}}

\item{...}{Additional arguments.
Used for deprecated arguments from previous versions of \code{\link[EGAnet]{itemStability}}}
}
\value{
Returns a list containing:

\item{membership}{A list containing:

\itemize{

\item{\strong{\code{empirical}}}
{The empirical memberships from the empirical \code{\link[EGAnet]{EGA}} result}

\item{\strong{\code{unique}}}
{The unique dimensions from the empirical \code{\link[EGAnet]{EGA}} result}

\item{\strong{\code{bootstrap}}}
{The memberships from the replicate samples in the \code{\link[EGAnet]{bootEGA}} results}
   }
}

\item{item.stability}{A list containing:

\itemize{

\item{\strong{\code{empirical.dimensions}}}
{The proportion of times each item replicated
within the empirical \code{\link[EGAnet]{EGA}} defined dimension.
This EGA result is defined using the input from
\code{\link[EGAnet]{bootEGA}}}

\item{\strong{\code{all.dimensions}}}
{The proportion of times each item replicated
in each of the empirical \code{\link[EGAnet]{EGA}} defined dimensions.
This EGA result is defined using the input from
\code{\link[EGAnet]{bootEGA}}}


   }
}

\item{plot}{A plot of the number of times each item
replicated within the empirical \code{\link[EGAnet]{EGA}} defined dimension.}

\item{mean.loadings}{Matrix of the average standardized network loading
(computed using \code{\link[EGAnet]{net.loads}}) for each item in each dimension}
}
\description{
Based on the \code{\link[EGAnet]{bootEGA}} results, this function
computes and plots the number of times an item (variable) is estimated
in the same factor/dimension as originally estimated by \code{\link[EGAnet]{EGA}} (\code{item.replication}).
The output also contains each item's replication frequency (i.e., proportion of
bootstraps that an item appeared in each dimension; \code{item.dim.rep}) as well as the average
network loading for each item in each dimension (\code{item.loadings}).
}
\examples{

# Load data
wmt <- wmt2[,7:24]

\dontrun{# Estimate EGA network
## plot.type = "qqraph" used for CRAN checks
## plot.type = "GGally" is the default
ega.wmt <- EGA(data = wmt, model = "glasso", plot.type = "qgraph")

# Estimate dimension stability
boot.wmt <- bootEGA(data = wmt, iter = 100, typicalStructure = TRUE,
plot.typicalStructure = TRUE, model = "glasso", plot.type = "qgraph",
type = "parametric", ncores = 2)
}

# Estimate item stability statistics
res <- itemStability(boot.wmt)

# Changing plot features (ggplot2)
## Changing colors (ignore warnings)
### qgraph Defaults
res$plot + 
    ggplot2::scale_color_manual(values = rainbow(max(res$membership$unique)))

### Pastel
res$plot + 
    ggplot2::scale_color_brewer(palette = "Pastel1")
    
## Changing Legend (ignore warnings)
res$plot + 
    ggplot2::scale_color_discrete(labels = "Intelligence")

}
\references{
Christensen, A. P., & Golino, H. (2021).
Estimating the stability of the number of factors via Bootstrap Exploratory Graph Analysis: A tutorial.
\emph{Psych}, \emph{3}(3), 479-500.

Christensen, A. P., Golino, H., & Silvia, P. J. (2020).
A psychometric network perspective on the validity and validation of personality trait questionnaires.
\emph{European Journal of Personality}, \emph{34}(6), 1095-1108.
}
\seealso{
\code{\link[EGAnet]{EGA}} to estimate the number of dimensions of an instrument using EGA and
\code{\link[EGAnet]{CFA}} to verify the fit of the structure suggested by EGA using confirmatory factor analysis.
}
\author{
Hudson Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
