% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LCT.R
\name{LCT}
\alias{LCT}
\title{Loadings Comparison Test}
\usage{
LCT(data, n, iter = 100)
}
\arguments{
\item{data}{Matrix or data frame.
A dataframe with the variables to be used in the test or a correlation matrix.
If the data used is a correlation matrix, the argument \code{n} will need to be specified}

\item{n}{Integer.
Sample size (if the data provided is a correlation matrix)}

\item{iter}{Integer.
Number of replicate samples to be drawn from a multivariate
normal distribution (uses \code{mvtnorm::mvrnorm}).
Defaults to \code{100}}
}
\value{
Returns a list containing:

\item{empirical}{Prediction of model based on empirical dataset only}

\item{bootstrap}{Prediction of model based on means of the loadings across
the bootstrap replicate samples}

\item{proportions}{Proportions of models suggested across bootstraps}

\item{omnibus}{An omnibus prediction based on a consensus of empirical,
bootstrap, and bootstrap proportions prediction. A consensus corresponds to
any combination of two predictions returning the same prediction}
}
\description{
An algorithm to identify whether data were generated from a
random, factor, or network model using factor and network loadings.
The algorithm uses heuristics based on theory and simulation. These
heuristics were then submitted to several deep learning neural networks
with 240,000 samples per model with varying parameters.
}
\examples{
\donttest{# Compute LCT
## Network model
LCT(data = wmt2[,7:24])$omnibus

## Factor model
LCT(data = NetworkToolbox::neoOpen)$omnibus}

}
\references{
Christensen, A. P., & Golino, H. (2020).
On the equivalency of factor and network loadings.
\emph{PsyArXiv}.
doi:\href{https://doi.org/10.31234/osf.io/xakez}{10.31234/osf.io/xakez}
}
\author{
Hudson F. Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen at gmail.com>
}
