% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.scores.R
\name{net.scores}
\alias{net.scores}
\title{Network Scores}
\usage{
net.scores(data, A, wc, ...)
}
\arguments{
\item{data}{Matrix or data frame.
Must be a dataset}

\item{A}{Matrix, data frame, or \code{\link[EGAnet]{EGA}} object. 
An adjacency matrix of network data}

\item{wc}{Numeric. 
A vector of community assignments.
Not necessary if an \code{\link[EGAnet]{EGA}} object
is input for argument \code{A}}

\item{...}{Additional arguments for \code{\link[igraph]{cluster_walktrap}}
and \code{\link[NetworkToolbox]{louvain}} community detection algorithms}
}
\value{
Returns a list containing:

\item{scores}{The standardized network scores for each participant
and community (including the overall score)}

\item{commCor}{Partial correlations between the specified or identified communities}

\item{loads}{Standardized network loadings for each item in each dimension
(computed using \code{\link[EGAnet]{net.loads}})}
}
\description{
This function computes network scores for
factor analysis models. Network scores are computed based on 
each node's \code{\link[NetworkToolbox]{strength}} within each
community (i.e., factor) in the network. These values are used
as network "factor loadings" for the weights of each item. Notably,
network analysis allows nodes to load onto more than one factor.
These loadings are considered in the factor scores. In addition,
if the construct is a hierarchy (e.g., personality questionnaire;
items in facet scales in a trait domain), then an overall
score can be computed (see argument \code{general}). These overall
scores are computed using \code{\link[NetworkToolbox]{comm.close}}
as weights, which are roughly similar to general factor loadings in a
CFA model (see Christensen, Golino, & Silvia, 2019). The score
estimates are roughly equivalent to the Maximum Likelihood method in
\code{lavaan}'s \code{\link[lavaan]{cfa}} function. An important difference
is that the network scores account for cross-loadings in their
estimation of scores.
}
\details{
For more details, type \code{vignette("Network_Scores")}
}
\examples{
# Load data
wmt <- wmt2[,7:24]

\dontrun{
# Estimate EGA
ega.wmt <- EGA(wmt)

}

# Network scores
net.scores(data = wmt, A = ega.wmt)

}
\references{
Christensen, A. P. (2018).
NetworkToolbox: Methods and measures for brain, cognitive, and psychometric network analysis in R.
\emph{The R Journal}, \emph{10}, 422-439.
doi: \href{https://doi.org/10.32614/RJ-2018-065}{10.32614/RJ-2018-065}

Christensen, A. P., Golino, H. F., & Silvia, P. J. (2019).
A psychometric network perspective on the measurement and assessment of personality traits.
\emph{PsyArXiv}.
doi: \href{https://doi.org/10.31234/osf.io/ktejp}{10.31234/osf.io/ktejp}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
