% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/drawEEM.R
\name{drawEEM}
\alias{drawEEM}
\alias{drawEEM.EEM}
\alias{drawEEM.EEMweight}
\alias{drawEEM.data.frame}
\alias{drawEEM.matrix}
\alias{drawEEM.numeric}
\title{Draw contour for EEM data}
\usage{
drawEEM(x, ...)

\method{drawEEM}{EEM}(x, n, xlab = "Excitation wavelength [nm]",
  ylab = "Emission wavelength [nm]", color.palette = matlab.like,
  nlevels = 50, title = NULL, ...)

\method{drawEEM}{EEMweight}(x, ncomp, xlab = "Excitation wavelength [nm]",
  ylab = "Emission wavelength [nm]", color.palette = matlab.like,
  nlevels = 50, title = NULL, ...)

\method{drawEEM}{matrix}(x, xlab = "Excitation wavelength [nm]",
  ylab = "Emission wavelength [nm]", color.palette = matlab.like,
  nlevels = 50, title = NULL, ...)

\method{drawEEM}{data.frame}(x, xlab = "Excitation wavelength [nm]",
  ylab = "Emission wavelength [nm]", color.palette = matlab.like,
  nlevels = 50, title = NULL, ...)

\method{drawEEM}{numeric}(x, xlab = "Excitation wavelength [nm]",
  ylab = "Emission wavelength [nm]", color.palette = matlab.like,
  nlevels = 50, title = NULL, ...)
}
\arguments{
\item{x}{a list of EEM data generated by \code{\link{readEEM}} function or
EEMweight object generated by \code{\link{extract}}-related functions.}

\item{...}{(optional) further arguments passed to other methods of \code{\link[graphics]{filled.contour}}}

\item{n}{sample number. The number should not exceed \code{length(EEM)}}

\item{xlab}{(optional) x-axis label}

\item{ylab}{(optional) y-axis label}

\item{color.palette}{(optional) contour color palette. See \code{\link[grDevices]{palette}} for more details}

\item{nlevels}{(optional) number of levels used to separate range of intensity value}

\item{title}{(optional) plot title}

\item{ncomp}{number of components}
}
\value{
A figure is returned on the graphic device
}
\description{
This function is a wrapper function for \code{\link{filled.contour}} to draw contour for EEM data.
}
\section{Methods (by class)}{
\itemize{
\item \code{EEM}: draw contour of EEM data created by \code{\link{readEEM}} function

\item \code{EEMweight}: draw contours of the output from \code{\link[EEM]{getLoading}} and
\code{\link[EEM]{getReg}}.

\item \code{matrix}: draw contour of a matrix with columns being
excitation wavelength and rows being emission wavelength

\item \code{data.frame}: draw contour of a data frame with columns being
excitation wavelength and rows being emission wavelength

\item \code{numeric}: draw contour of a vector of numeric values which have names in
the format of EX...EM...
}}
\examples{
# method for class "EEM"
data(applejuice)
drawEEM(applejuice, 1) # draw contour of the first sample

# method for class "EEMweight"
applejuice_uf <- unfold(applejuice) # unfold list into matrix
result <- prcomp(applejuice_uf)
drawEEM(getLoading(result), 1) # plot loading of the first PC
}

