r.hist <- function(n,h){
  df_hist <- data.frame(lower = h$breaks[-length(h$breaks)],
                        upper = h$breaks[-1])
  df_hist$prob <- (df_hist$upper - df_hist$lower) * h$density
  sample1 <- sample(1:nrow(df_hist), size = n,
                    replace = TRUE, prob = df_hist$prob)

  random_values <- mapply(function(row) {
    runif(1, min = df_hist$lower[row],
          max = df_hist$upper[row])
  }, sample1)
  return(random_values)
}









