% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sanity_checks.R
\name{assert_no_duplicate}
\alias{assert_no_duplicate}
\title{Assert that a dataframe has one row per patient}
\usage{
assert_no_duplicate(df, by = NULL, id_col = get_subjid_cols())
}
\arguments{
\item{df}{a dataframe}

\item{by}{\emph{(optional)} grouping columns}

\item{id_col}{the name of the columns holding patient ID}
}
\value{
the \code{df} dataset, unchanged
}
\description{
Check that there is no duplicate on the column holding patient ID in a pipeable style. \cr
Mostly useful after joining two datasets.
}
\examples{
\dontrun{
#without duplicate => no error, continue the pipeline
tibble(subjid=c(1:10)) \%>\% assert_no_duplicate() \%>\% nrow()

#with duplicate => throws an error
tibble(subjid=c(1:10, 1:2)) \%>\% assert_no_duplicate() \%>\% nrow()

#By groups
df = tibble(subjid=rep(1:10, 4), visit=rep(c("V1", "V2"), 2, each=10), 
            group=rep(c("A", "B"), each=20))
df \%>\% assert_no_duplicate() #error
df \%>\% assert_no_duplicate(by=c(visit, group)) #no error
}
}
