% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{get_meta_cols}
\alias{get_meta_cols}
\title{Get columns shared by most datasets}
\usage{
get_meta_cols(min_pct = getOption("edc_meta_cols_pct", 0.95))
}
\arguments{
\item{min_pct}{Default=\code{0.95}. The minimal proportion of datasets a column has to reach. Subject ID is always excluded.}
}
\value{
a character vector
}
\description{
In most trialmaster exports, many datasets share a certain amount of columns containing
meta-data that are often irrelevant to the point. This function identifies the columns
that are present in at least 95\% of datasets (by default)
}
\examples{
tm = edc_example_mixed()
load_list(tm)
meta_cols = get_meta_cols()
long_mixed \%>\% dplyr::select(-dplyr::any_of(meta_cols))
}
