% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KSCovL2sup.R
\name{KSCovL2}
\alias{KSCovL2}
\title{L2-norm based test of equality of several covariance functions}
\usage{
KSCovL2(data, Nsim = 1000)
}
\arguments{
\item{data}{The list variable containing k groups of presmoothed functional observations. 
Each element of the list is a p (number sampling points) by n (sample size) matrix.}

\item{Nsim}{Number of pseudo samples by resampling, default=1000.}
}
\value{
The p-value of the test.
}
\description{
L2-norm test of equality of several covariance functions, using resampling  
to approximate the null distribution.
}
\details{
L2-norm test of equality of several covariance functions, see Zhang (2013), Guo et al. (2016).
}
\examples{
fdata<-list();
fdata[[1]]<-matrix(rnorm(200),20,10);
fdata[[1]]<-matrix(rnorm(300),20,15);
KSCovL2(fdata)
KSCovL2(fdata, 500)
}
\references{
ZHANG (2013), GUO et al. (2016), PAPARODITIS and SAPATINAS (2016).
}
\seealso{
\code{\link{KSCovL2WS}}, \code{\link{KSCovsup}}.
}
