#' Calculate the polygenic risk scores
#'
#' @param sigmaHat2 parameters generated by 'findPara', estimated variations
#' @param muHat parameters generated by 'findPara', estimated effect sizes
#' @param X bed file generated by 'extractInfo'
#' @return Polygenic risk scores for each individual calculated by the EBPRS model (S).
#' @description
#' Function that generates PRS for each individual.
#' @export
#' @references
#' Song, S., Jiang, W., Hou, L. and Zhao, H. Leveraging effect size distributions to improve polygenic risk scores derived from genome-wide association studies. \emph{Submitted}.
#' @examples
#' S <- generateScore(sigmaHat2=rep(1,100),muHat=rep(0.1,100),
#' X=matrix(sample(0:1,size=1000,replace=TRUE),10,100) )
#' @seealso
#' \code{\link{extractInfo}}
#'
#' \code{\link{findPara}}
#' @author
#' Shuang Song, Wei Jiang, Lin Hou and Hongyu Zhao





generateScore <- function(sigmaHat2, muHat,X){
  newmuHat=muHat/sqrt(sigmaHat2)
  n0=nrow(X)
  if(is.null(n0)){
    S <- sum(X*newmuHat)
    return(S)
  }
  else{
    S=rep(0,n0)
    for(l in 1:n0){
      S[l]=sum(X[l,]*newmuHat)
      if(l%%500==0){
        ll <- paste("Finished",l,"individuals")
        print(ll)
      }

    }
    return(S)

  }

}
