% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VAR_INMB.R
\docType{class}
\name{VAR_INMB}
\alias{VAR_INMB}
\title{A Reference Class to represent the Hypothetical variance of the Incremental Net Monetary Benefit}
\description{
Hypothetical variance of the Incremental Net Monetary Benefit.
}
\section{Fields}{

\describe{
\item{\code{sdc}}{: common standard deviation of costs in each group}

\item{\code{sde}}{: common standard deviation of effectiveness in each group}

\item{\code{rho}}{: coefficient of correlation between the difference in costs (dc) and the difference in effectiveness (de)}

\item{\code{object_lambda}}{: an object lambda.
Create one with \link{create_object_lambda}.
It contains lambda : the ceiling cost-effectiveness ratio or maximum acceptable cost of a unit of effectiveness}
}}
\section{Methods}{

 \describe{
 \item{set_sdc(sdc):}{Sets the common standard deviation of costs in each group for this VAR_INMB object}
 \item{set_sde(sde):}{Sets the common standard deviation of effectiveness in each group for this VAR_INMB object}
 \item{set_rho(rho):}{Sets the coefficient of correlation between the difference in costs (dc) and the difference in effectiveness (de)}
 \item{set_object_lambda(object_lambda):}{Sets the object_lambda of this VAR_INMB object}
 \item{get_var_inmb():}{Return the calculated hypothetical variance of the Incremental Net Monetary Benefit (INMB)}
 }
}
\examples{
## First, create a lambda object
object_lambda <- create_object_lambda (20000)
## Then, create a var_inmb object
var_inmb <- create_object_var_inmb(sde=0.12, sdc=2100, rho=0.1, object_lambda=object_lambda)
var_inmb$get_var_inmb()
}
\seealso{
\link{create_object_var_inmb_direct} to directly provide a value for the variance of the Incremental Net Monetary Benefit

\link{create_object_var_inmb_diff} to calculate the theoretical standard deviation of the expected INB with different standard deviation in the reference and the experimental group

\link{create_object_var_inmb} the constructor
}

