% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DynComm.R
\docType{methods}
\name{addRemoveEdges}
\alias{addRemoveEdges}
\alias{DynComm.addRemoveEdges}
\alias{DynComm.addRemove}
\alias{DynComm.add}
\title{addRemoveEdges(graphAddRemove)}
\usage{
DynComm.addRemoveEdges(dyncomm,graphAddRemove)
DynComm.addRemove(dyncomm,graphAddRemove)
DynComm.add(dyncomm,graphAddRemove)
}
\arguments{
\item{dyncomm}{A DynComm object, if not using the inline version of the 
function call}

\item{graphAddRemove}{Either the matrix or the filename that contains the 
edges to add/remove}
}
\value{
FALSE if any kind of error occurred. Otherwise, TRUE
}
\description{
This method reads edges from either a matrix or a file and adds or removes 
them to/from the graph.
}
\details{
If the weight is exactly zero, the edge is removed from the graph.

If a vertex, mentioned in the source or destination, does not exist it will be 
added to the graph.

If any post processing algorithm exists, it is automatically calculated after
the main algorithm.

\describe{
  \item{Matrix input}{
The matrix must have at least two columns with the source and destination
vertices.

If all edges are to be added with the default weight, a third column 
is optional. 

If any edge is to be removed, the third column is mandatory.
  }
  \item{File input}{
The file must have only one edge per line, with values separated by a white
space (both SPACE and TAB work in any amount and combination). The line must 
end with a newline character (also known as linefeed, LF or '\\n').

The first value is the source vertex, the second is the destination vertex, 
and the third is the weight.

The weight can be ommited if the edge is to be added using the default weight
of 1 (one), or if the parameter to ignore weights was set.

The method detects automatically if the weight is present on a row by row basis 
so some rows may have weights defined and others not.
  }
}
}
\examples{
library(DynComm)
Parameters<-matrix(c("e","0.1","w", "FALSE"),ncol=2, byrow=TRUE)
dc<-DynComm(ALGORITHM$LOUVAIN,CRITERION$MODULARITY,Parameters)
#adding edges with the use of a matrix
dc$addRemoveEdges(
 matrix(
   c(10,20,10,30,20,30,30,60,40,60,40,50,50,70,60,70)
   ,ncol=2,byrow=TRUE)
)

dc<-DynComm(ALGORITHM$LOUVAIN,CRITERION$MODULARITY,Parameters)
#adding edges with the use of a file
dc$addRemoveEdges(system.file("extdata","graphAddRemoveFile.txt",package = "DynComm"))

}
\seealso{
\code{\link{DynComm}} , \code{\link{postProcess}}
}
\author{
poltergeist0
}
