% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/byParticipant.R
\name{byParticipant}
\alias{byParticipant}
\title{Helper function to do DstarM analyses by participant.}
\usage{
byParticipant(data, resD, resND, argsEstDstarM = list(), argsEstND = list(),
  argsEstObserved = list(), uniqueArgs = FALSE)
}
\arguments{
\item{data}{data.frame with a $id column. For other requirements, see
\code{\link{estDstarM}}.}

\item{resD}{list of decision models (all of class DstarM).}

\item{resND}{list of nondecision models (all of class DstarM).}

\item{argsEstDstarM}{Additional arguments for \code{\link{estDstarM}}.}

\item{argsEstND}{Additional arguments for \code{\link{estND}}.}

\item{argsEstObserved}{Additional arguments for \code{\link{estObserved}}.}

\item{uniqueArgs}{Logical, are the additional arguments specified using one list
for all participants or does the list of additional arguments contain lists with
participant specific arguments?}
}
\description{
A helper function to do run DstarM functions per participant.
Supported functions are: \code{\link{estDstarM}}, \code{\link{estND}}, and
\code{\link{estObserved}}.
}
\examples{
\dontrun{
library(DstarM)
tt = seq(0, 5, .1)
pars = c(.8, 2, .5, .5, .5, # condition 1
         .8, 3, .5, .5, .5, # condition 2
         .8, 4, .5, .5, .5) # condition 3
pdfND = dbeta(tt, 10, 30)
# simulate data for 2 participants
n = 1.2e3
data = rbind(simData(n = n, pars = pars, tt = tt, pdfND = pdfND),
             simData(n = n, pars = pars, tt = tt, pdfND = pdfND))
# add participant column
data$pp = rep(1:2, each = n)
# define restriction matrix
restr = matrix(1:5, 5, 3)
restr[2, -1] = 6:7 # allow drift rates to differ
# fix variance parameters
fixed = matrix(c('sz1', .5, 'sv1', .5), 2, 2)
## Run D*M analysis by pp
resDpp = byParticipant(data = data,
                       argsEstDstarM = list(tt = tt,
                                            restr = restr,
                                            fixed = fixed,
                                            Optim = list(parallelType = 1)))
coef(resDpp)
plot(resDpp)
resNDpp = byParticipant(resD = resDpp,
                        argsEstND = list(Optim = list(parallelType = 1)))
plot(resNDpp, xlim = 0:1)
lines(tt, pdfND, col = 3, type = 'b')
resObsPp = byParticipant(resD = resDpp,
                         resND = resNDpp)
plot(resObsPp)
}
}
