% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addIndication.R
\name{addIndication}
\alias{addIndication}
\title{Get indication for a target cohort}
\usage{
addIndication(
  x,
  cdm = lifecycle::deprecated(),
  indicationCohortName,
  indicationGap = 0,
  unknownIndicationTable = NULL,
  indicationDate = "cohort_start_date"
)
}
\arguments{
\item{x}{Table in the cdm}

\item{cdm}{A cdm reference created using CDMConnector}

\item{indicationCohortName}{Name of indication cohort table}

\item{indicationGap}{Gap between the event and the indication}

\item{unknownIndicationTable}{Tables to search unknown indications}

\item{indicationDate}{Date of the indication}
}
\value{
Same cohort adding the indications
}
\description{
Get indication for a target cohort
}
\examples{
\donttest{
library(DrugUtilisation)
library(CodelistGenerator)

cdm <- mockDrugUtilisation()

indications <- list("headache" = 378253, "asthma" = 317009)
cdm <- generateConceptCohortSet(
  cdm, indications, "indication_cohorts"
)

acetaminophen <- getDrugIngredientCodes(cdm, "acetaminophen")
cdm <- generateDrugUtilisationCohortSet(cdm, "drug_cohort", acetaminophen)

cdm[["drug_cohort"]] \%>\%
  addIndication(cdm, "indication_cohorts", indicationGap = c(0, 30, 365))
}

}
