% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dailyDose.R
\name{addDailyDose}
\alias{addDailyDose}
\title{add daily dose information to a drug_exposure table}
\usage{
addDailyDose(
  drugExposure,
  cdm = attr(drugExposure, "cdm_reference"),
  ingredientConceptId
)
}
\arguments{
\item{drugExposure}{drugExposure it must contain drug_concept_id, quantity,
drug_exposure_start_date and drug_exposure_end_date as columns}

\item{cdm}{A cdm reference}

\item{ingredientConceptId}{ingredientConceptId for which to filter the
drugs of interest}
}
\value{
same input table
}
\description{
add daily dose information to a drug_exposure table
}
\examples{
\donttest{
library(DrugUtilisation)
library(dplyr)

cdm <- mockDrugUtilisation()

cdm[["drug_exposure"]] \%>\%
  filter(drug_concept_id == 2905077) \%>\%
  addDailyDose(ingredientConceptId = 1125315)
}

}
