% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern.R
\name{addPattern}
\alias{addPattern}
\title{add pattern info to a table containing drug_strength information}
\usage{
addPattern(drugList, cdm, ingredientConceptId)
}
\arguments{
\item{drugList}{Table in the cdm that has contain drug_concept_id}

\item{cdm}{cdm_reference}

\item{ingredientConceptId}{ingredientConceptId}
}
\value{
It adds pattern_id and unit to the current table
}
\description{
add pattern info to a table containing drug_strength information
}
\examples{
\donttest{
library(DrugUtilisation)
library(dplyr)

cdm <- mockDrugUtilisation()

cdm$drug_exposure \%>\%
  addPattern(cdm, 1125315)

cdm$concept \%>\%
  filter(domain_id == "Drug") \%>\%
  select(drug_concept_id = concept_id) \%>\%
  addPattern(cdm, 1125315)
}

}
