% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/HSES.R
\name{HSES}
\alias{HSES}
\title{Expected Shortfall of a portfolio using Historical Estimator}
\usage{
HSES(Ra, cl)
}
\arguments{
\item{Ra}{Vector corresponding to profit and loss distribution}

\item{cl}{Number between 0 and 1 corresponding to confidence level}
}
\value{
Expected Shortfall of the portfolio
}
\description{
Estimates the Expected Shortfall (aka. Average Value at Risk or Conditional
Value at Risk) using historical estimator approach for the specified
confidence level and the holding period implies by data frequency.
}
\examples{
# Computes Historical Expected Shortfall for a given profit/loss
   # distribution and confidence level
   a <- rnorm(100) # generate a random profit/loss vector
   HSES(a, 0.95)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.

Cont, R., Deguest, R. and Scandolo, G. Robustness and sensitivity analysis
of risk measurement procedures. Quantitative Finance, 10(6), 2010, 593-606.

Acerbi, C. and Tasche, D. On the coherence of Expected Shortfall. Journal
of Banking and Finance, 26(7), 2002, 1487-1503

Artzner, P., Delbaen, F., Eber, J.M. and Heath, D. Coherent Risk Measures
of Risk. Mathematical Finance 9(3), 1999, 203.

Foellmer, H. and Scheid, A. Stochastic Finance: An Introduction in Discrete
Time. De Gryuter, 2011.
}

