% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/method-default.R
\name{getDockerInstanceStatus}
\alias{getDockerInstanceStatus}
\alias{IsDockerInstanceInitializing}
\alias{IsDockerInstanceRunning}
\alias{IsDockerInstanceStopped}
\alias{getDockerInstanceStatus,ANY-method}
\alias{IsDockerInstanceInitializing,ANY-method}
\alias{IsDockerInstanceRunning,ANY-method}
\alias{IsDockerInstanceStopped,ANY-method}
\title{Get the instance status}
\usage{
getDockerInstanceStatus(provider, instanceHandles, verbose)

IsDockerInstanceInitializing(provider, instanceHandles, verbose)

IsDockerInstanceRunning(provider, instanceHandles, verbose)

IsDockerInstanceStopped(provider, instanceHandles, verbose)

\S4method{getDockerInstanceStatus}{ANY}(provider, instanceHandles, verbose = 0L)

\S4method{IsDockerInstanceInitializing}{ANY}(provider, instanceHandles, verbose = 0L)

\S4method{IsDockerInstanceRunning}{ANY}(provider, instanceHandles, verbose = 0L)

\S4method{IsDockerInstanceStopped}{ANY}(provider, instanceHandles, verbose = 0L)
}
\arguments{
\item{provider}{S4 \code{CloudProvider} object. The service provider.}

\item{instanceHandles}{List. A list of instance handles.}

\item{verbose}{Integer. The verbose level, default 1.}
}
\value{
\code{getDockerInstanceStatus} : A character vector with each element corresponding
to an instance in \code{instanceHandles}. Each element must be one of three possible characters
\code{"initializing"}, \code{"running"} or \code{"stopped"}

\code{IsDockerInstanceInitializing}, \code{IsDockerInstanceRunning}, \code{IsDockerInstanceStopped}:
A logical vector with each element corresponding to the status of each instance
}
\description{
Get the instance status. Unless you have a faster implementation, you only need to
define \code{getDockerInstanceStatus}. The function \code{getDockerInstanceStatus} should return
a character vector with each element corresponding to an instance in \code{instanceHandles}.
Each element must be one of three possible characters \code{"initializing"}, \code{"running"} or
\code{"stopped"}.
The default \code{getDockerInstanceStatus} returns
a vector of character "running" with the same length of the input instance handles.
}
