% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/method-default.R
\name{registerParallelBackend}
\alias{registerParallelBackend}
\alias{deregisterParallelBackend}
\alias{deregisterParallelBackend,ANY-method}
\title{Register/deregister the parallel backend}
\usage{
registerParallelBackend(container, cluster, verbose, ...)

deregisterParallelBackend(container, cluster, verbose, ...)

\S4method{deregisterParallelBackend}{ANY}(container, cluster, verbose = 0L)
}
\arguments{
\item{container}{The worker container.}

\item{cluster}{S4 \code{DockerCluster} object.}

\item{verbose}{Integer. The verbose level, default 1.}

\item{...}{The additional parameter that will be passed to the registration function}
}
\value{
No return value
}
\description{
Register/deregister the parallel backend. These methods will be dispatched based on
the \emph{worker} container. The parallel framework depends on the container image.
If the container uses the \code{foreach} framework, there is no need
to define \code{deregisterParallelBackend} as its default method will deregister the
foreach backend. There is no default method defined for \code{registerParallelBackend}.
}
