% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast_appli.R
\name{direct.discrete.BH}
\alias{direct.discrete.BH}
\title{Direct Application of Multiple Testing Procedures to Dataset}
\usage{
direct.discrete.BH(
  dat,
  test.fun,
  test.args = NULL,
  alpha = 0.05,
  direction = "su",
  adaptive = FALSE,
  ret.crit.consts = FALSE,
  select.threshold = 1,
  preprocess.fun = NULL,
  preprocess.args = NULL
)
}
\arguments{
\item{dat}{input data; must be suitable for the first parameter of the provided \code{preprocess.fun} function or, if \code{preprocess.fun} is \code{NULL}, for the first parameter of the \code{test.fun} function.}

\item{test.fun}{function \strong{from package \code{\link[DiscreteTests:DiscreteTests-package]{DiscreteTests}}}, i.e. one whose name ends with \verb{*.test.pv} and which performs hypothesis tests and provides an object with p-values and their support sets; can be specified by a single character string (which is automatically checked for being a suitable function \strong{from that package} and may be abbreviated) or a single function object.}

\item{test.args}{optional named list with arguments for \code{test.fun}; the names of the list fields must match the test function's parameter names. The first parameter of the test function (i.e. the data) MUST NOT be included!}

\item{alpha}{single real number strictly between 0 and 1 indicating the target FDR level.}

\item{direction}{single character string specifying whether to perform a step-up (\code{"su"}; the default) or step-down procedure (\code{"sd"}).}

\item{adaptive}{single boolean specifying whether to conduct an adaptive procedure or not.}

\item{ret.crit.consts}{single boolean specifying whether critical constants are to be computed.}

\item{select.threshold}{single real number strictly between 0 and 1 indicating the largest raw p-value to be considered, i.e. only p-values below this threshold are considered and the procedures are adjusted in order to take this selection effect into account; if \code{threshold = 1} (the default), all raw p-values are selected.}

\item{preprocess.fun}{optional function for pre-processing the input \code{data}; its result must be suitable for the first parameter of the \code{test.fun} function.}

\item{preprocess.args}{optional named list with arguments for \code{preprocess.fun}; the names of the list fields must match the pre-processing function's parameter names. The first parameter of the test function (i.e. the data) MUST NOT be included!}
}
\description{
Apply the [HSU], [HSD], [AHSU] or [AHSD] procedure, with or without
computing the critical constants,
to a data set of 2x2 contingency tables using Fisher's exact tests which
may have to be transformed before computing p-values.
}
\examples{
X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1 - X1
Y2 <- N2 - X2
df <- data.frame(X1, Y1, X2, Y2)
df

DBH.su <- direct.discrete.BH(df, "fisher", direction = "su")
summary(DBH.su)

DBH.sd <- direct.discrete.BH(df, "fisher", direction = "sd")
DBH.sd$Adjusted
summary(DBH.sd)

ADBH.su <- direct.discrete.BH(df, "fisher", direction = "su", adaptive = TRUE)
summary(ADBH.su)

ADBH.sd <- direct.discrete.BH(df, "fisher", direction = "sd", adaptive = TRUE)
ADBH.sd$Adjusted
summary(ADBH.sd)

}
