% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBH_fun.R
\name{kernel.DBH}
\alias{kernel.DBH}
\title{Kernel functions for DBH}
\usage{
kernel.DBH(msg = "", stepf, pv.numer, pv.denom, bigMem = FALSE,
  verbose = TRUE)
}
\arguments{
\item{msg}{a character string to be displayed if \code{verbose=TRUE}.}

\item{stepf}{a list of the CDFs under the null hypothesis of each p-value.}

\item{pv.numer}{a numeric vector. Contains all values of the p-values supports if we search for the critical constants. If not, contains only the observed p-values. Must be in increasing order.}

\item{pv.denom}{a numeric vector. Identical to \code{pv.numer} for a step-down procedure. Equals \code{c.m} for a step-up procedure.}

\item{bigMem}{a boolean. If \code{TRUE}, the code uses matrixes and functions of the apply family as far as possible (faster for small number of hypotheses and support size, but slower otherwise due to memory management overhead). If \code{FALSE}, computations are done with \code{for} loops and chunks to conserve memory.}

\item{verbose}{a boolean indicating if \code{msg} must be printed. Used when \code{bigMem=TRUE}, to print messages informing if in-memory computation was successful or if loops and chunks were used as fallback.}
}
\value{
A vector of transformed p-values.
}
\description{
Kernel functions that transform 
observed p-values or their support according to [HSU] and [HSD].
The output is used by \code{\link{DBH}}.
The end user should not use it.
}
\details{
This version: 2017-09-14.
}
\examples{
data(amnesia)

#We only keep the first 100 lines to keep the computations fast.
amnesia<-amnesia[1:100,]

#Construction of the p-values and their support
amnesia.formatted <- fisher.pvalues.support(amnesia)
raw.pvalues <- amnesia.formatted$raw
pCDFlist <- amnesia.formatted$support

m <- length(raw.pvalues)
alpha <- 0.05

#Compute the step functions from the supports
stepf <- build.stepfuns(pCDFlist)

#We stay in a step-down context, where pv.numer=pv.denom,
#for the sake of simplicity

#If not searching for critical constants, we use only the observed p-values
sorted.pvals <- sort(raw.pvalues)
y <- kernel.DBH("", stepf, sorted.pvals, sorted.pvals)

#If searching for critical constants, we use (almost) the complete support
pv.list.all <- unique(sort(as.numeric(unlist(pCDFlist))))
# apply the shortcut drawn from Lemma 3, that is
# c.1 >= the effective critical value associated to (alpha/m)/(1 + alpha/m)
pv.list<-short.eff(pv.list.all, (alpha/m)/(1 + alpha/m) )
# then re-add the observed p-values (needed to compute the adjusted p-values),
# because we may have removed some of them the shortcut
pv.list <- sort(unique(c(pv.list, sorted.pvals)))
# compute transformed support
y <- kernel.DBH("", stepf, pv.list, pv.list)

}
\seealso{
\code{\link{DBH}}, \code{\link{DiscreteFDR}}
}
