% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boots_g.R
\name{boots_g}
\alias{boots_g}
\title{Coefficient Estimates across Bootstrapped Samples}
\usage{
boots_g(seqg, boots = 1000)
}
\arguments{
\item{seqg}{A fitted sequential_g estimate, computed by \code{\link{sequential_g}}.}

\item{boots}{The number of bootstrap replicates. Defaults to 1000.}
}
\value{
An object of type \env{seqgboots} which is a matrix with \env{boots}
rows and columns for each coefficient in the \env{seqg} model. Use \env{summary} 
to provide summary statistics, such as mean and quantiles.
}
\description{
Performs a simple bootstrap of a fitted DirectEffects model by re-estimating
the model with bootstrap samples.
}
\examples{
\donttest{
data(ploughs)
form <- women_politics ~ plow +
 agricultural_suitability + tropical_climate + large_animals + rugged |
 years_civil_conflict + years_interstate_conflict  + oil_pc +
 european_descent + communist_dummy + polity2_2000 |
 centered_ln_inc + centered_ln_incsq
s1 <- sequential_g(form, ploughs)

out.boots <- boots_g(s1)

summary(out.boots)
}
}
