% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/DiffCorr.R
\name{get.eigen.molecule}
\alias{get.eigen.molecule}
\title{Get eigen molecule}
\usage{
get.eigen.molecule(data, groups, whichgroups = NULL, methods = "svd",
  n = 10)
}
\arguments{
\item{data}{a data matrix ([data.frame object] row: molecules,
col: samples or replicates)}

\item{groups}{a vector of group memberships as returned by cutree}

\item{whichgroups}{a vector of group numbers to examine}

\item{methods}{c("svd", "nipals", "rnipals", "bpca", "ppca"). See also pca() function in pcaMethods package}

\item{n}{top n principal components}
}
\value{
the resulting vector.
}
\description{
Get eigen molecule
}
\examples{
library(pcaMethods)
data(golub, package = "multtest")
hc.mol1 <- cluster.molecule(golub[1:100, 1:27], "pearson", "average")
g1 <- cutree(hc.mol1, h=0.6)
res1 <- get.eigen.molecule(golub[1:100,], g1)
}
\author{
Atsushi Fukushima
}

