% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim.R
\name{optims}
\alias{optims}
\title{Title Multi-local optimization wrapper for optim, using (possibly parallel) multistart.}
\usage{
optims(
  pars,
  fn,
  fn.NaN = NaN,
  .apply = "mclapply",
  pars.eps = 1e-05,
  control = list(),
  ...
)
}
\arguments{
\item{pars}{starting points for optim}

\item{fn}{objective function, like in optim().}

\item{fn.NaN}{replacement value of fn when returns NaN}

\item{.apply}{loop/parallelization backend for multistart ("mclapply", "lapply" or "foreach")}

\item{pars.eps}{minimal distance between two solutions to be considered different}

\item{control}{control parameters for optim()}

\item{...}{additional arguments passed to optim()}
}
\value{
list with best solution and all solutions
}
\description{
Title Multi-local optimization wrapper for optim, using (possibly parallel) multistart.
}
\examples{
fn = function(x) ifelse(x==0,1,sin(x)/x)
# plot(fn, xlim=c(-20,20))
optim( par=5,                     fn,lower=-20,upper=20,method='L-BFGS-B')
optims(pars=t(t(seq(-20,20,,20))),fn,lower=-20,upper=20,method='L-BFGS-B')

# Branin function (3 local minimas)
f = function (x) {
  x1 <- x[1] * 15 - 5
  x2 <- x[2] * 15
  (x2 - 5/(4 * pi^2) * (x1^2) + 5/pi * x1 - 6)^2 + 10 * (1 - 1/(8 * pi)) * cos(x1) + 10
}
# expect to find 3 local minimas
optims(pars=matrix(runif(100),ncol=2),f,method="L-BFGS-B",lower=c(0,0),upper=c(1,1))
}
\author{
Yann Richet, IRSN
}
