\name{contourview.km}
\alias{contourview.km}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Plot a contour view of a kriging model, including design points }
\description{
  Plot a contour view of a kriging model: mean response surface, fitted points and
  confidence surfaces. Provide a better understanding of the kriging model behaviour.
}

\usage{
contourview.km(model, type = "UK", center = NULL,
                 npoints = 20,
                 col_points = "red",
                 col_surf = "blue",
                 nlevels = 10,
                 bg_blend = 1,
                 mfrow = NULL,
                 Xname = NULL, yname = NULL, Xscale = 1, yscale = 1,
                 ylim = NULL, title = NULL,
                 ...)
}

%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{model}{an object of class \code{"km"}.}
  \item{type}{the kriging type to use for model prediction.}
  \item{center}{
    optional coordinates (as a list or data frame) of the
    center of the section view if the model's dimension is > 2.
  }
  \item{npoints}{
    an optional number of points to discretize plot of
    response surface and uncertainties.
  }
  \item{col_points}{color of points.}
  \item{col_surf}{color for the surface.}
  \item{nlevels}{
    number of contour levels to display.
  }
  \item{bg_blend}{
    an optional factor of alpha (color channel)
    blending used to plot design points outside from this section.
  }
  \item{mfrow}{
    an optional list to force \code{par(mfrow = ...)} call. The default
    value  \code{NULL} is automatically set for compact view.
  }
  \item{ylim}{
    an optional list to force y range for all plots. Default
    value \code{NULL}  is automatically set to include all design points
    (and their 1-99 percentiles).
  }
  \item{Xname}{an optional list of string to overload names for X. }
  \item{yname}{an optional string to overload name for y.}
  \item{Xscale}{an optional factor to scale X.}
  \item{yscale}{an optional factor to scale y.}
  \item{title}{an optional overload of main title.}
  \item{\dots}{further arguments passed to the first call of \code{plot3d}. }
}
\details{
  Experimental points are plotted with fading colors. Points that fall in the
  specified section (if any) have the color specified \code{col_points} while
  points far away from the center have shaded versions of the same
  color. The amount of fading is determined using the Euclidean distance
  between the plotted point and \code{center}.

  The variables chosen with their number are to be found in the \code{X} slot of the
  model. Thus they are 'spatial dimensions' but not 'trend variables'.
  
}
%%\value{No value.}
\author{Yann Richet, IRSN }
\note{
  The confidence bands are computed using normal quantiles and the
  standard error given by \code{predict.km}.
}
\seealso{
  See \code{\link{sectionview3d.km}} and the
  \code{\link[DiceKriging]{km}} function in the \pkg{DiceKriging}
  package.
}

\keyword{models}
\examples{
## A 2D example - Branin-Hoo function. See DiceKriging package manual 
## a 16-points factorial design, and the corresponding response
d <- 2; n <- 16
design.fact <- expand.grid(seq(0, 1, length = 4), seq(0, 1, length = 4))
design.fact <- data.frame(design.fact); names(design.fact)<-c("x1", "x2")
y <- branin(design.fact) 

## kriging model 1 : matern5_2 covariance structure, no trend, no nugget effect

m1 <- km(design = design.fact, response = y)

## the same as contourview.km
contourview(m1)

## change colors
contourview(m1, col_points = "firebrick", col_surf = "SpringGreen2")

## change colors,  use finer grid and add needles
contourview(m1, npoints = c(50, 30), col_points = "orange",
  col_surf = "SpringGreen2") 

}
